package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinGoodsSkuInfoVo", description = "商品SKU信息")
@Data
public class GoblinGoodsSkuInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 7139250447538358198L;
    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "单品的编号[45]")
    private String skuNo;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 16, value = "ISBN，针对CD/图书等[50]")
    private String skuIsbn;
    @ApiModelProperty(position = 17, value = "总库存")
    private Integer stock;
    @ApiModelProperty(position = 18, value = "单品库存")
    private Integer skuStock;
    @ApiModelProperty(position = 19, value = "预警库存")
    private Integer warningStock;
    @ApiModelProperty(position = 20, value = "单品销售价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 21, value = "单品价格[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 22, value = "单品会员价格[20,2]")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 23, value = "单品的重量[20,2]")
    private BigDecimal weight;
    @ApiModelProperty(position = 24, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private String buyFactor;
    @ApiModelProperty(position = 25, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private String buyRoster;
    @ApiModelProperty(position = 26, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 27, value = "商品的店铺ID，如果是平台的则为0")
    private String storeId;
    @ApiModelProperty(position = 28, value = "单品有效期")
    private LocalDateTime skuValidity;
    @ApiModelProperty(position = 29, value = "是否是虚拟商品[0-否|1-是]")
    private String virtualFlg;
    @ApiModelProperty(position = 30, value = "审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 31, value = "审核拒绝原因[256]")
    private String reason;
    @ApiModelProperty(position = 32, value = "单品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 33, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;
    @ApiModelProperty(position = 34, value = "上架时间")
    private LocalDateTime shelvesAt;
    @ApiModelProperty(position = 34, value = "活动Id")
    private String marketId;
    private String createdBy;
    private LocalDateTime createdAt;
    private String updatedBy;
    private LocalDateTime updatedAt;
    @ApiModelProperty(position = 35, value = "物流模版ID")
    private String logisticsTemplate;

    @ApiModelProperty(position = 40, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;

    private static final GoblinGoodsSkuInfoVo obj = new GoblinGoodsSkuInfoVo();

    public static GoblinGoodsSkuInfoVo getNew() {
        try {
            return (GoblinGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSkuInfoVo();
        }
    }
}
