package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreCertificationVo", description = "店铺认证信息")
@Data
public class GoblinStoreCertificationVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -7125674300755279796L;
    @ApiModelProperty(position = 11, value = "证件类型[1-二代居民身份证]")
    private String personCertType;
    @ApiModelProperty(position = 12, value = "证件姓名[32]")
    private String personName;
    @ApiModelProperty(position = 13, value = "证件号码[32]")
    private String personCertCode;
    @ApiModelProperty(position = 14, value = "证件有效期[50]")
    private String personCertValidity;
    @ApiModelProperty(position = 15, value = "证件是否长期有效[0-否|1-是]")
    private String personCertLasting;
    @ApiModelProperty(position = 16, value = "证件正面照[256]")
    private String personCertFpic;
    @ApiModelProperty(position = 17, value = "证件背面照[256]")
    private String personCertBpic;
    @ApiModelProperty(position = 18, value = "证件背面照[256]")
    private String personCertSpic;
    @ApiModelProperty(position = 19, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;
    @ApiModelProperty(position = 20, value = "省ID[20]")
    private String provinceId;
    @ApiModelProperty(position = 21, value = "省名称[32]")
    private String provinceName;
    @ApiModelProperty(position = 22, value = "市ID[20]")
    private String cityId;
    @ApiModelProperty(position = 23, value = "市名称[32]")
    private String cityName;
    @ApiModelProperty(position = 24, value = "县ID[20]")
    private String countyId;
    @ApiModelProperty(position = 25, value = "县名称[32]")
    private String countyName;
    @ApiModelProperty(position = 26, value = "详细地址[128]")
    private String busAddress;
    @ApiModelProperty(position = 27, value = "商户名称[64]")
    private String busName;
    @ApiModelProperty(position = 28, value = "统一社会信用代码[32]")
    private String busCertCode;
    @ApiModelProperty(position = 29, value = "营业执照有效期[50]")
    private String busCertValidity;
    @ApiModelProperty(position = 30, value = "证件是否长期有效[0-否|1-是]")
    private String busCertLasting;
    @ApiModelProperty(position = 31, value = "营业执照照片[256]")
    private String busCertPic;
    @ApiModelProperty(position = 32, value = "资质证书[256]")
    private String busQualityPic;
    private String updatedBy;
    private LocalDateTime updatedAt;
}
