package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.param.MerchantFieldsApplyParam;
import com.liquidnet.service.merchant.service.IMerchantFieldsAppliesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * <p>
 * 场地表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10010)
@Api(tags = "场地")
@Slf4j
@Validated
@RestController
@RequestMapping("fields")
public class MerchantFieldsController {

    @Autowired
    IMerchantFieldsAppliesService merchantFieldsAppliesService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "申请场地")
    @PostMapping("apply")
    public ResponseDto<Object> apply(@Valid @RequestBody MerchantFieldsApplyParam parameter) {
        return ResponseDto.success(merchantFieldsAppliesService.apply(parameter));
    }



}
