package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuListVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigInteger;
import java.time.LocalDateTime;

/**
 * <p>
 * 预约关联sku和spu表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-08
 */
@Data
public class AnticipateValueVo implements Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * sku名称
     */
    @ApiModelProperty(value = "sku名称")
    private String skuName;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    @ApiModelProperty("预约状态(0:未开始，1:可预约，3:已结束)")
    private Integer state;

    @ApiModelProperty("预约规则")
    private String rule;

    @ApiModelProperty("预约人数")
    private BigInteger aboutPeople;

    private static final AnticipateValueVo obj = new AnticipateValueVo();

    public static AnticipateValueVo getNew() {
        try {
            return (AnticipateValueVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AnticipateValueVo();
        }
    }

}
