package com.liquidnet.service.sweet.handler;

import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>
 * 2021草莓音乐节海报活动菜单点击
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Component
@Slf4j
public class StrawberryPosterHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        redisUtils.setStrawberryPosterClick(wxMessage.getFromUser(), 10 * 60);

        // TODO: 2021/11/25 线上改成正规文案
        return WxMpXmlOutMessage.TEXT().content("您已进入活动，请回复姓名，zhengzai.tv, 10分钟内回复有效")
                .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                .build();
    }
}
