package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.param.PayAgainParam;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Slf4j
@Api(tags = "订单相关-支付相关")
@RestController
@RequestMapping("/order/pay")
public class GoblinOrderController {

    @Autowired
    IGoblinOrderService goblinAppOrderService;

    @PostMapping("pre")
    @ApiOperation("下单")
    public ResponseDto<GoblinPayInnerResultVo> getZhengzaiMarketList(@RequestBody EncryptedReq<GoblinOrderParam> param) {
        GoblinOrderParam payOrderParam = param.getData();
        return goblinAppOrderService.checkOrder(payOrderParam);
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("fc7bce6d6c2213b866f76493f92224b7")
    public ResponseDto<GoblinPayInnerResultVo> getZhengzaiMarketList(@RequestBody GoblinOrderParam param) {
        return goblinAppOrderService.checkOrder(param);
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(@ModelAttribute @Valid SyncOrderParam syncOrderParam) {
        return null;
    }

    @PostMapping("payAgain")
    @ApiOperation("再次支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinPayInnerResultVo> payAgain(@RequestBody @Valid PayAgainParam param) {
        return goblinAppOrderService.payAgain(param);
    }

    @PostMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @Valid String orderId) {
        return goblinAppOrderService.checkOrderResult(orderId);
    }
}
