package com.liquidnet.client.admin.zhengzai.candy.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRelateAdminService;
import com.liquidnet.common.cache.redis.util.AbstractRedisUtil;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponRelateParam;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRelate;
import com.liquidnet.service.candy.mapper.CandyCouponRelateMapper;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 券适用关联配置 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-19
 */
@Service
public class CandyCouponRelateAdminServiceImpl extends ServiceImpl<CandyCouponRelateMapper, CandyCouponRelate> implements ICandyCouponRelateAdminService {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private ICandyCouponAdminService candyCouponAdminService;

    @Override
    public AjaxResult relate(CandyMgtCouponRelateParam couponRelateParam) {
        String couponId = couponRelateParam.getCouponId();
        LambdaQueryWrapper<CandyCoupon> couponLambdaQueryWrapper = Wrappers.lambdaQuery();
        couponLambdaQueryWrapper.eq(CandyCoupon::getCouponId, couponId);
        couponLambdaQueryWrapper.eq(CandyCoupon::getState, 1);
        CandyCoupon coupon = candyCouponAdminService.getOne(couponLambdaQueryWrapper);
        if (null == coupon) return AjaxResult.warn("券不存在");
        if (coupon.getCouType() != 101) return AjaxResult.warn("当前操作只支持优先券类型");

        String key;
        Integer scope = couponRelateParam.getScope();
        switch (scope) {
            case 1:
                key = KylinRedisConst.COUPON_ROADSHOWS.concat(couponId);
                break;
            default:
                return AjaxResult.warn("适用范围无效");
        }

        AbstractRedisUtil redisKylinUtil = redisDataSourceUtil.getRedisKylinUtil();
        List<String> valList = (List<String>) redisKylinUtil.get(key);
        if (!CollectionUtils.isEmpty(valList)) {
            return AjaxResult.warn("该券已存在关联配置");
        }

        String loginName = ShiroUtils.getLoginName();
        LocalDateTime now = LocalDateTime.now();
        List<CandyCouponRelate> couponRelateList = new ArrayList<>();
        List<String> idList = couponRelateParam.getIdList();
        for (String id : idList) {
            CandyCouponRelate couponRelate = new CandyCouponRelate();
            couponRelate.setCouponId(couponId);
            couponRelate.setBusiId(id);
            couponRelate.setScope(scope);
            couponRelate.setOperator(loginName);
            couponRelate.setCreatedAt(now);

            couponRelateList.add(couponRelate);
        }

        if (this.saveBatch(couponRelateList)) {
            redisKylinUtil.set(key, idList);

            return AjaxResult.success();
        }
        return AjaxResult.warn("操作失败");
    }
}
