use
dev_ln_scene;

-- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_nft_ex_code`;
CREATE TABLE `goblin_nft_ex_code`
(
    `mid`         bigint(0) UNSIGNED NOT NULL AUTO_INCREMENT,
    `code_id`     varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '兑换码id',
    `activity_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '活动id',
    `sku_id`      varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '款式id',
    `box_sku_id`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '盲盒抽取的款式id',
    `code`        varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '兑换码',
    `state`       tinyint(0) UNSIGNED NULL DEFAULT 1 COMMENT '兑换码状态 1未兑换 2已兑换 3已失效',
    `redeem_uid`  varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '兑换用户id',
    `redeem_at`   datetime(0) NULL DEFAULT NULL COMMENT '兑换时间',
    `admin_uid`   varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '操作用户id',
    `created_at`  datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
    `updated_at`  datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE,
    INDEX         `idx_nft_code_id`(`code_id`) USING BTREE,
    INDEX         `idx_nft_activity_id`(`activity_id`) USING BTREE,
    INDEX         `idx_nft_sku_id`(`sku_id`) USING BTREE,
    INDEX         `idx_nft_code`(`code`) USING BTREE,
    INDEX         `idx_nft_redeem_uid`(`redeem_uid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'NFT兑换码表' ROW_FORMAT = Dynamic;

-- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_nft_ex_activity`;
CREATE TABLE `goblin_nft_ex_activity`
(
    `mid`         bigint(0) UNSIGNED NOT NULL AUTO_INCREMENT,
    `activity_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '活动id',
    `title`       varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '活动标题',
    `created_at`  datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
    `updated_at`  datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE,
    INDEX         `idx_nft_activity_id`(`activity_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'NFT兑换活动表' ROW_FORMAT = Dynamic;

DROP TABLE IF EXISTS `goblin_nft_ex_sku`;
CREATE TABLE `goblin_nft_ex_sku`
(
    `mid`           bigint(0) UNSIGNED NOT NULL AUTO_INCREMENT,
    `activity_id`   varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '活动id',
    `store_id`      varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '店铺id',
    `spu_id`        varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '商品id',
    `sku_id`        varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '款式id',
    `unbox`         char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci     NOT NULL DEFAULT '0' COMMENT '是否盲盒[0-否|1-是]',
    `ex_stock`      int(0) UNSIGNED NOT NULL DEFAULT 0 COMMENT '兑换库存',
    `ex_limit`      int(0) UNSIGNED NOT NULL DEFAULT 0 COMMENT '兑换限购',
    `ex_start_time` datetime(0) NULL DEFAULT NULL COMMENT '兑换生效开始时间',
    `ex_stop_time`  datetime(0) NULL DEFAULT NULL COMMENT '兑换生效结束时间',
    `created_at`    datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE,
    INDEX           `idx_nft_ex_activity_id`(`activity_id`) USING BTREE,
    INDEX           `idx_nft_ex_spu_id`(`spu_id`) USING BTREE,
    INDEX           `idx_nft_ex_sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = 'NFT兑换活动关联SKU表' ROW_FORMAT = Dynamic;


DROP TABLE IF EXISTS `goblin_nft_ex_code_task`;
CREATE TABLE `goblin_nft_ex_code_task`
(
    `mid`           bigint(0) NOT NULL AUTO_INCREMENT,
    `task_id`       varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '定时id',
    `activity_id`   varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动id',
    `store_id`      varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '店铺id',
    `spu_id`        varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'spuid',
    `sku_id`        varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'skuid',
    `unbox`         varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否盲盒[0-否|1-是]',
    `ex_stock`      int(0) NOT NULL COMMENT '兑换库存',
    `ex_limit`      int(0) NOT NULL COMMENT '兑换限购',
    `ex_start_time` datetime(0) NOT NULL COMMENT '兑换生效开始时间',
    `ex_stop_time`  datetime(0) NOT NULL COMMENT '兑换生效结束时间',
    `typ`           tinyint(0) NULL DEFAULT NULL COMMENT '是否生效 0:否 1:是',
    `created_at`    datetime(0) NOT NULL COMMENT '创建时间',
    `updated_at`    datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '兑换码定时任务表' ROW_FORMAT = Dynamic;


DROP TABLE IF EXISTS `goblin_nft_ex_code_task_relation`;
CREATE TABLE `goblin_nft_ex_code_task_relation`
(
    `mid`        bigint(0) NOT NULL AUTO_INCREMENT,
    `task_id`    varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '定时id',
    `sku_id`     varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sku_id',
    `stock`      int(0) NOT NULL COMMENT '库存',
    `created_at` datetime(0) NOT NULL COMMENT '创建时间',
    `updated_at` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '兑换码定时任务生成副表' ROW_FORMAT = Dynamic;

