package com.liquidnet.service.platform.service.impl.goblin;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.AdamUserInfoDto;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.CodeExcelVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.PageInfoVo;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import com.liquidnet.service.goblin.mapper.GoblinGoodsSkuMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExSkuMapper;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.ObjectUtil;
import com.sun.org.apache.xpath.internal.operations.Bool;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/20 5:36 下午
 */
@Service
@Slf4j
public class GoblinNftExCodeServiceImpl implements IGoblinNftExCodeService {

    @Autowired
    private GoblinGoodsSkuMapper goblinGoodsSkuMapper;
    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    private GoblinNftExSkuMapper goblinNftExSkuMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private AdamUserMapper adamUserMapper;
    @Value("${liquidnet.service.order.url}")
    private String orderUrl;

    @Override
    public PageInfoVo selectCodePageList(GoblinNftExCodeParam goblinNftExCodeParam) {

        // 入参
        GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
        goblinNftExCode.setCode(goblinNftExCodeParam.getCode());
        goblinNftExCode.setActivityId(goblinNftExCodeParam.getActivityId());
        goblinNftExCode.setState(goblinNftExCodeParam.getState());
        goblinNftExCode.setRedeemUid(goblinNftExCodeParam.getUserId());
        goblinNftExCode.setIsDrivi(goblinNftExCodeParam.getIsDrivi());
        if (StringUtil.isNotBlank(goblinNftExCodeParam.getSkuName())) {
            // 根据藏品名称获取 skuIds
            String skuName = goblinNftExCodeParam.getSkuName();
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectSkuLikeName(skuName);
            if (goblinGoodsSkus.size() <= 0) {
                return new PageInfoVo();
            }
            StringBuffer skuIds = new StringBuffer();
            for (GoblinGoodsSku goblinGoodsSku : goblinGoodsSkus) {
                skuIds.append(goblinGoodsSku.getSkuId()).append(",");
            }
            goblinNftExCode.setSkuId(skuIds.deleteCharAt(skuIds.length() - 1).toString());
        }


        PageHelper.startPage(goblinNftExCodeParam.getPageNum(), 20, true);
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectGoblinNftCode(goblinNftExCode);

        int count = goblinNftExCodeMapper.selectGoblinNftCodeCount(goblinNftExCode);

        StringBuffer skuIds = new StringBuffer();
        StringBuffer acticityIds = new StringBuffer();
        for (GoblinNftExCode gnc : goblinNftExCodes) {
            if (StringUtil.isNotBlank(gnc.getSkuId())) {
                skuIds.append(gnc.getSkuId()).append(",");
            } else {
                skuIds.append(gnc.getBoxSkuId()).append(",");
            }

            acticityIds.append(gnc.getActivityId()).append(",");
        }

        // 获取返回对象实例
        ArrayList<GoblinNftExCodeVo> goblinNftExCodeArrayList = ObjectUtil.getGoblinNftExCodeArrayList();


        if (StringUtil.isNotBlank(skuIds)) {
            // 批量查询
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectBySkuIds(skuIds.toString());
            for (GoblinNftExCode gnc : goblinNftExCodes) {
                for (GoblinGoodsSku goblinGoodsSku : goblinGoodsSkus) {

                    GoblinNftExCodeVo goblinNftExCodeVo = GoblinNftExCodeVo.getNew().copy(gnc);
                    if (StringUtil.isNotBlank(gnc.getBoxSkuId()) && gnc.getBoxSkuId().equals(goblinGoodsSku.getSkuId())) {
                        goblinNftExCodeVo.setSkuName(goblinGoodsSku.getName());
                        goblinNftExCodeArrayList.add(goblinNftExCodeVo);
                        break;
                    } else {
                        if (gnc.getSkuId().equals(goblinGoodsSku.getSkuId())) {
                            goblinNftExCodeVo.setSkuName(goblinGoodsSku.getName());
                            goblinNftExCodeArrayList.add(goblinNftExCodeVo);
                            break;
                        }
                    }


                }
            }
        }


        // 根据活动ids 获取兑换活动和sku的关联
        List<GoblinNftExSku> goblinNftExSkus = goblinNftExSkuMapper.selectGoblinNftExSkuByActivityIds(acticityIds.toString());

        Map<String, List<GoblinNftExSku>> map = new HashMap<>();
        for (GoblinNftExSku goblinNftExSku : goblinNftExSkus) {
            if (map.get(goblinNftExSku.getActivityId()) == null) {
                map.put(goblinNftExSku.getActivityId(), new ArrayList<>());
            }
            map.get(goblinNftExSku.getActivityId()).add(goblinNftExSku);
        }


        for (GoblinNftExCodeVo gnc : goblinNftExCodeArrayList) {
            List<GoblinNftExSku> goblinNftExSkuList = map.get(gnc.getActivityId());
            for (GoblinNftExSku goblinNftExSku : goblinNftExSkuList) {

                if (StringUtil.isNotBlank(gnc.getBoxSkuId()) && gnc.getSkuId().equals(goblinNftExSku.getSkuId())) {
                    gnc.setExStartTime(goblinNftExSku.getExStartTime());
                    gnc.setExStopTime(goblinNftExSku.getExStopTime());
                    break;
                } else {
                    if (gnc.getSkuId().equals(goblinNftExSku.getSkuId())) {
                        gnc.setExStartTime(goblinNftExSku.getExStartTime());
                        gnc.setExStopTime(goblinNftExSku.getExStopTime());
                        break;
                    }
                }
            }
        }


        PageInfoVo pageInfo = new PageInfoVo(goblinNftExCodeArrayList, count);

        return pageInfo;
    }

    @Override
    public Boolean defDrivLoseCode(String codeIds) {

        // 获取兑换码
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectByIds(codeIds);

        List<String> codes = new ArrayList<>();
        Map<String, Integer> skuMap = new HashMap<>();

        for (GoblinNftExCode goblinNftExCode : goblinNftExCodes) {
            // redis 主动失效
            codes.add(goblinNftExCode.getCode());
            goblinNftExCode.setState(3);
            goblinNftExCode.setUpdatedAt(LocalDateTime.now());

            String skuId = "";
            if (StringUtil.isNotBlank(goblinNftExCode.getBoxSkuId())) {
                skuId = goblinNftExCode.getBoxSkuId();
            } else {
                skuId = goblinNftExCode.getSkuId();
            }

            if (StringUtil.isNotBlank(skuId)) {
                if (skuMap.get(skuId) == null) {
                    skuMap.put(skuId, 0);
                }

                Integer number = skuMap.get(skuId);
                skuMap.put(skuId, number + 1);
            }
            goblinRedisUtils.removeCode(goblinNftExCode.getCode());
        }

        if (skuMap.size() > 0) {
            for (String key : skuMap.keySet()) {
                // goblinRedisUtils.incrSkuStock(null, key, skuMap.get(key));
            }
        }
        // 批量修改
        goblinNftExCodeMapper.updateCodes(goblinNftExCodes);
        return true;
    }

    @Override
    @Transactional
    public ResponseDto<Boolean> addAirdrop(GoblinNftExCodeParam goblinNftExCodeParam) {
        String code = goblinNftExCodeParam.getCode();
        String phone = goblinNftExCodeParam.getPhone();

        AdamUserInfoDto adamUserInfoDto = adamUserMapper.selectByPhone(phone);
        if (adamUserInfoDto == null) {
            return ResponseDto.failure("用户不存在!");
        }

        // 根据兑换code查询兑换码信息
        GoblinNftExCode goblinNftExCode = goblinNftExCodeMapper.selectGoblinNftCodeByCode(code);
        if (goblinNftExCode == null) {
            return ResponseDto.failure("兑换码不存在!");
        }

        if (goblinNftExCode.getState().equals(2)) {
            return ResponseDto.failure("兑换码已领取!");
        }

        GoblinNftExCodeVo goblinNftExCodeVo = goblinRedisUtils.getGoblinNftExCodeVo(goblinNftExCode.getCode());
        if (goblinNftExCodeVo == null) {
            return ResponseDto.failure("兑换码已失效!");
        }

        if (goblinNftExCodeVo.getState().equals(2)) {
            return ResponseDto.failure("兑换码已领取!");
        }


        // 验证吗时间校验
        try {
            MultiValueMap<String, String> params = new LinkedMultiValueMap();
            params.add("code", code);
            params.add("userId", adamUserInfoDto.getUid());
            MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add("Authorization", "Bearer " + CurrentUtil.getToken());
            String post = HttpUtil.post(orderUrl + "/order/goblin/nft/airdrop", params, headers);
            ResponseDto<Boolean> rsp = JsonUtils.fromJson(post, new TypeReference<ResponseDto<Boolean>>() {
            });
            if (rsp.getData() != null && rsp.getData()) {
                goblinNftExCode.setAdminUid(goblinNftExCodeParam.getAdminUid());
                goblinNftExCodeMapper.updateCodeAdminUid(goblinNftExCode);
            }else {
                return ResponseDto.failure(rsp.getMessage());
            }
            return rsp;
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure("发送公投失败！");
        }
    }

    @Override
    public void excel(HttpServletResponse httpServletResponse, GoblinNftExCodeParam goblinNftExCodeParam) {
        // 入参
        GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
        goblinNftExCode.setCode(goblinNftExCodeParam.getCode());
        goblinNftExCode.setActivityId(goblinNftExCodeParam.getActivityId());
        goblinNftExCode.setState(goblinNftExCodeParam.getState());
        goblinNftExCode.setRedeemUid(goblinNftExCodeParam.getUserId());
        goblinNftExCode.setIsDrivi(goblinNftExCodeParam.getIsDrivi());
        if (StringUtil.isNotBlank(goblinNftExCodeParam.getSkuName())) {
            // 根据藏品名称获取 skuIds
            String skuName = goblinNftExCodeParam.getSkuName();
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectSkuLikeName(skuName);
            if (goblinGoodsSkus.size() <= 0) {
                return;
            }
            StringBuffer skuIds = new StringBuffer();
            for (GoblinGoodsSku goblinGoodsSku : goblinGoodsSkus) {
                skuIds.append(goblinGoodsSku.getSkuId()).append(",");
            }
            goblinNftExCode.setSkuId(skuIds.deleteCharAt(skuIds.length() - 1).toString());
        }


        PageHelper.startPage(goblinNftExCodeParam.getPageNum(), 20, true);
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectGoblinNftCode(goblinNftExCode);
        StringBuffer skuIds = new StringBuffer();
        StringBuffer acticityIds = new StringBuffer();
        for (GoblinNftExCode gnc : goblinNftExCodes) {
            if (StringUtil.isNotBlank(gnc.getSkuId())) {
                skuIds.append(gnc.getSkuId()).append(",");
            } else {
                skuIds.append(gnc.getBoxSkuId()).append(",");
            }

            acticityIds.append(gnc.getActivityId()).append(",");
        }

        // 获取返回对象实例
        ArrayList<GoblinNftExCodeVo> goblinNftExCodeArrayList = ObjectUtil.getGoblinNftExCodeArrayList();


        if (StringUtil.isNotBlank(skuIds)) {
            // 批量查询
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectBySkuIds(skuIds.toString());
            for (GoblinNftExCode gnc : goblinNftExCodes) {
                for (GoblinGoodsSku goblinGoodsSku : goblinGoodsSkus) {

                    GoblinNftExCodeVo goblinNftExCodeVo = GoblinNftExCodeVo.getNew().copy(gnc);
                    if (StringUtil.isNotBlank(gnc.getBoxSkuId()) && gnc.getBoxSkuId().equals(goblinGoodsSku.getSkuId())) {
                        goblinNftExCodeVo.setSkuName(goblinGoodsSku.getName());
                        goblinNftExCodeArrayList.add(goblinNftExCodeVo);
                        break;
                    } else {
                        if (gnc.getSkuId().equals(goblinGoodsSku.getSkuId())) {
                            goblinNftExCodeVo.setSkuName(goblinGoodsSku.getName());
                            goblinNftExCodeArrayList.add(goblinNftExCodeVo);
                            break;
                        }
                    }


                }
            }
        }


        // 根据活动ids 获取兑换活动和sku的关联
        List<GoblinNftExSku> goblinNftExSkus = goblinNftExSkuMapper.selectGoblinNftExSkuByActivityIds(acticityIds.toString());

        Map<String, List<GoblinNftExSku>> map = new HashMap<>();
        for (GoblinNftExSku goblinNftExSku : goblinNftExSkus) {
            if (map.get(goblinNftExSku.getActivityId()) == null) {
                map.put(goblinNftExSku.getActivityId(), new ArrayList<>());
            }
            map.get(goblinNftExSku.getActivityId()).add(goblinNftExSku);
        }


        ArrayList<CodeExcelVo> codeExcelVoArrayList = ObjectUtil.getCodeExcelVoArrayList();
        for (GoblinNftExCodeVo gnc : goblinNftExCodeArrayList) {
            List<GoblinNftExSku> goblinNftExSkuList = map.get(gnc.getActivityId());
            for (GoblinNftExSku goblinNftExSku : goblinNftExSkuList) {

                if (StringUtil.isNotBlank(gnc.getBoxSkuId()) && gnc.getSkuId().equals(goblinNftExSku.getSkuId())) {
                    gnc.setExStartTime(goblinNftExSku.getExStartTime());
                    gnc.setExStopTime(goblinNftExSku.getExStopTime());
                    break;
                } else {
                    if (gnc.getSkuId().equals(goblinNftExSku.getSkuId())) {
                        gnc.setExStartTime(goblinNftExSku.getExStartTime());
                        gnc.setExStopTime(goblinNftExSku.getExStopTime());
                        break;
                    }
                }
            }


            CodeExcelVo codeExcelVo = new CodeExcelVo();
            codeExcelVo.setCode(gnc.getCode());
            String val = "";
            switch (gnc.getState()) {
                case 1:
                    val = "未兑换";
                    break;
                case 2:
                    val = "已兑换";
                    break;
                case 3:
                    val = "已失效";
                    break;
                default:
                    val = "状态处理中";
            }
            codeExcelVo.setSkuName(gnc.getSkuName());
            codeExcelVo.setState(val);
            codeExcelVo.setExcelStartTime(gnc.getExStartTime().toString());
            codeExcelVo.setExcelStopTime(gnc.getExStopTime().toString());
            codeExcelVo.setRedeemUid(gnc.getRedeemUid());
            codeExcelVoArrayList.add(codeExcelVo);
        }


        try {
            writeExcel(httpServletResponse, codeExcelVoArrayList, "兑换码excel", "sheet1", CodeExcelVo.class);
        } catch (Exception e) {
            log.error("导出excel失败！");
        }

    }


    /**
     * 导出
     *
     * @param response
     * @param data
     * @param fileName
     * @param sheetName
     * @param clazz
     * @throws Exception
     */
    public static void writeExcel(HttpServletResponse response, List<? extends Object> data, String fileName,
                                  String sheetName, Class clazz) throws Exception {
        // 表头样式
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        // 设置表头居中对齐
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        // 内容样式
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        // 设置内容靠左对齐
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy =
                new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        EasyExcel.write(getOutputStream(fileName, response), clazz).excelType(ExcelTypeEnum.XLSX).sheet(sheetName)
                .registerWriteHandler(horizontalCellStyleStrategy).doWrite(data);

    }

    private static OutputStream getOutputStream(String fileName, HttpServletResponse response) throws Exception {
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + "-" + LocalDate.now() + ".xlsx");
        return response.getOutputStream();
    }


}
