package com.liquidnet.service.account.wallet.dto;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.vo.WalletAccountInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * WalletQueryResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletQueryResult", description = "Result of wallet query")
public class WalletQueryResult extends WalletCallResult<WalletQueryParam> {
    private static final long serialVersionUID = 2139002215454350775L;
    @ApiModelProperty(position = 11, value = "Currency code list")
    private Map<String, String> currencyMap;
    @ApiModelProperty(position = 12, value = "Wallet status list")
    private Map<Integer, String> statusMap;
    @ApiModelProperty(position = 13, value = "Wallet pay-status list")
    private Map<Integer, String> payStatusMap;
    @ApiModelProperty(position = 13, value = "Wallet account info list")
    private PageInfo<WalletAccountInfoVo> pageInfo;

    public WalletQueryResult() {
    }

    public WalletQueryResult(PageInfo<WalletAccountInfoVo> pageInfo) {
        this.pageInfo = pageInfo;
    }

    public WalletQueryResult(Map<String, String> currencyMap, Map<Integer, String> statusMap, Map<Integer, String> payStatusMap, PageInfo<WalletAccountInfoVo> pageInfo) {
        this.currencyMap = currencyMap;
        this.statusMap = statusMap;
        this.payStatusMap = payStatusMap;
        this.pageInfo = pageInfo;
    }

    public WalletQueryResult(String code, String message) {
        super(code, message);
    }

    public Map<String, String> getCurrencyMap() {
        return currencyMap;
    }

    public Map<Integer, String> getStatusMap() {
        return statusMap;
    }

    public Map<Integer, String> getPayStatusMap() {
        return payStatusMap;
    }

    public PageInfo<WalletAccountInfoVo> getPageInfo() {
        return pageInfo;
    }
}
