package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.dto.*;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.kylin.dao.TicketAndStatusDao;
import com.liquidnet.service.kylin.dao.report.KylinPerformancesDto;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.entity.SmilePrice;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.entity.dto.ShowBaseVoDto;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import com.liquidnet.service.smile.mapper.SmilePriceMapper;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileShowServiceImpl extends ServiceImpl<SmileSchoolMapper, SmileSchool> implements ISmileShowService {

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    KylinPerformancesMapper kylinPerformancesMapper;

    @Autowired
    KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Autowired
    KylinTicketsMapper kylinTicketsMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmilePriceMapper smilePriceMapper;

    @Autowired
    KylinPerformanceStatusMapper kylinPerformanceStatusMapper;

    @Autowired
    private KylinOrderTicketsMapper orderTicketsMapper;

    @Override
    public TableDataInfo listShow(SmileShowParam smileShowParam) {
        PageHelper.startPage(smileShowParam.getPageNum(), smileShowParam.getPageSize());
        TableDataInfo rspData = new TableDataInfo();
        //查询所有代理的演出id
        List<KylinPerformancesDto> kylinPerformancesList = kylinPerformancesMapper.selectPerIdByAgent();
        List<ShowVo> showVoList = kylinPerformancesList.stream().map(kylinPerformancesDto -> {
            ShowVo vo = ShowVo.getNew().copy(kylinPerformancesDto);
            Integer ordNum = kylinOrderTicketRelationsMapper.concatByAgentDed(kylinPerformancesDto.getPerformancesId());
            vo.setTotalOutAgent(ordNum);
            //打款状态
            vo.setStatus(smileRedisUtils.getShowStatus(kylinPerformancesDto.getPerformancesId()));
            return vo;
        }).collect(Collectors.toList());
        rspData.setCode(0);
        rspData.setRows(showVoList);
        rspData.setTotal(new PageInfo(kylinPerformancesList).getTotal());
        return rspData;
    }

    @Override
    public AjaxResult sort(ShowSort showSort) {

        //查询数据库是否又该顺序的演出
        kylinPerformancesMapper.updateComment(showSort.getSort());
        kylinPerformancesMapper.updateCommentByPer(showSort.getSort(), showSort.getPerformancesId());
        log.info("redis show key:{}", showSort.getPerformancesId());
        //判断该演出是否修改过票提
        if (smileRedisUtils.getShowIds().stream().anyMatch(showId -> showSort.getPerformancesId().equals(showId))) {
            List<String> showIds = smileRedisUtils.getShowIds();
            showIds.remove(showSort.getPerformancesId());
            showIds.add(0, showSort.getPerformancesId());
            smileRedisUtils.setShowIds(showIds);

            return AjaxResult.success();
        } else {
            return AjaxResult.warn("清先为演出设置票提！");
        }

        /*//获取排序演出id
        List<String> collect = kylinPerformancesMapper.selectPerIdByAgent().stream().map(KylinPerformances::getPerformancesId).collect(Collectors.toList());
        String perId = StringUtils.join(collect, ",");
        //保存所有演出id带顺序
        smileRedisUtils.setShowIds(perId);*/

    }

    @Override
    public AjaxResult price(SmilePriceParam smilePriceParam) {
        SmilePrice smilePrice = new SmilePrice();
        BeanUtils.copyProperties(smilePriceParam, smilePrice);
        //查询演出状态
        AjaxResult showStatue = showStatue(smilePriceParam);
        if (showStatue != null) {
            return showStatue;
        }
        Integer status = smileRedisUtils.getShowPriceUid(smilePriceParam.getPerformancesId(), smilePriceParam.getUid());
        if (smilePriceParam.getStatus().equals(status)) {
            return AjaxResult.warn("不可重复打款");
        }
        if (smilePriceParam.getStatus().equals(0)) {
            //计算该用户的佣金(旧)
            /*Map userPerformance = orderTicketsMapper.getUserPerformanceByUidAndProId(smilePriceParam.getUid(), smilePriceParam.getPerformancesId());
            BigDecimal price = userPerformance.get("commiss") == null ? new BigDecimal(0) : new BigDecimal(userPerformance.get("commiss").toString());*/
            UserData userDataByUid = smileRedisUtils.getUserDataByUid(smilePriceParam.getPerformancesId(), smilePriceParam.getUid());

            //保存打款数据
            if (userDataByUid != null) {
                BigDecimal price = new BigDecimal("0");
                List<UserDataAgentVo> dataAgentVos = userDataByUid.getDataAgentVos();
                for (UserDataAgentVo userDataAgentVo : dataAgentVos) {
                    price = price.add(userDataAgentVo.getCommission());
                }
                smilePrice.setPrice(price);
                smilePrice.setCreatedDate(LocalDateTime.now());

                String userDataJson = JSON.toJSONString(userDataByUid);
                //保存打款金额
                smilePrice.setRecord(userDataJson);
                smilePriceMapper.insert(smilePrice);
                smileRedisUtils.setPriceByUid(smilePriceParam.getPerformancesId(), smilePriceParam.getUid());
                //计算总营收
                BigDecimal userTotalPrice = smileRedisUtils.getUserTotalPrice(smilePriceParam.getUid());
                smileRedisUtils.setUserTotalPrice(smilePriceParam.getUid(), price.add(userTotalPrice));
            }else {
                return AjaxResult.warn("打款失败,请刷新重试。");
            }
            /*smilePriceMapper.insert(smilePrice);
            smileRedisUtils.setPriceByUid(smilePriceParam.getPerformancesId(), smilePriceParam.getUid());
            //计算总营收
            BigDecimal userTotalPrice = smileRedisUtils.getUserTotalPrice(smilePriceParam.getUid());
            smileRedisUtils.setUserTotalPrice(smilePriceParam.getUid(), price.add(userTotalPrice));*/
        }
        return AjaxResult.success();
    }

    private AjaxResult showStatue(SmilePriceParam smilePriceParam) {
        LambdaQueryWrapper<KylinPerformances> queryWrapper = Wrappers.lambdaQuery(KylinPerformances.class);
        queryWrapper.eq(KylinPerformances::getPerformancesId, smilePriceParam.getPerformancesId());
        LocalDateTime timeEnd = kylinPerformancesMapper.selectOne(queryWrapper).getTimeEnd();
        if (timeEnd.isAfter(LocalDateTime.now())) {
            return AjaxResult.warn("演出尚未结束不能进行打款");
        }
        return null;
    }

    @Override
    public AjaxResult getShowById(String performancesId) {
        if (!StringUtils.isEmpty(performancesId)) {
            ShowVoById showVoById = new ShowVoById();
            //根据演出ID查询演出数据演出数据
            KylinPerformanceVo kylinPerformanceVo = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
            if (kylinPerformanceVo == null) {
                return AjaxResult.warn("演出未找到");
            }
            //票提集合  根据演出id查询票提id
            List<ShowAgentVo> showAgentVoList = new ArrayList<>();
            List<ShowTicketVo> showTicketVoList = new ArrayList<>();
            List<SmileAgent> smileAgents = getSmileAgentsByProId(performancesId);
            if (smileAgents == null) {
                return AjaxResult.warn("该演出未开启代理票种");
            }
            Map<String, SmileAgent> map = getSmileAgentMap(smileAgents);

            //代理票的id
            List<String> ticketsIdList = smileAgents.stream().map(SmileAgent::getTicketId).collect(Collectors.toList());

            if (ticketsIdList.size() > 0) {
                ShowTicketVo totalShowTicketVo = new ShowTicketVo();
                totalShowTicketVo.setTitle("合计");
                totalShowTicketVo.setAgentSaleNum(BigDecimal.ZERO);
                totalShowTicketVo.setTotalPrice(BigDecimal.ZERO);
                //根据票提IDs查询票信息
                List<TicketAndStatusDao> ticketAndStatusDaoList = kylinTicketsMapper.selectTicketsByIds(ticketsIdList);
                if (ticketAndStatusDaoList != null && ticketAndStatusDaoList.size() > 0) {
                    for (TicketAndStatusDao ticketAndStatusDao : ticketAndStatusDaoList) {
                        SmileAgent smileAgent = map.get(ticketAndStatusDao.getTicketsId());

                        ShowAgentVo showAgentVo = getShowAgentVo(performancesId, ticketAndStatusDao, smileAgent);

                        ShowTicketVo showTicketVo = new ShowTicketVo();
                        showTicketVo.setTitle(ticketAndStatusDao.getTitle());
                        //单价
                        showTicketVo.setPrice(ticketAndStatusDao.getPrice());
                        showTicketVo.setType(ticketAndStatusDao.getType() == 1 ? "单日票" : "通票");
                        showTicketVo.setUseEnd(ticketAndStatusDao.getUseEnd());
                        showTicketVo.setUseStart(ticketAndStatusDao.getUseStart());
                        showTicketVo.setTotalGeneral(ticketAndStatusDao.getTotalGeneral());

                        //根据演出id和票提id查询出一共卖出票的数量
                        Map numAndPrice = kylinOrderTicketsMapper.selectNumAndPrice(performancesId, ticketAndStatusDao.getTicketsId());
                        //销售总数
                        showTicketVo.setAgentSaleNum(numAndPrice != null ? (BigDecimal) numAndPrice.get("agentSaleNum") : BigDecimal.valueOf(0));
                        //销售金额
                        showTicketVo.setTotalPrice(numAndPrice != null ? (BigDecimal) numAndPrice.get("totalPrice") : BigDecimal.valueOf(0));

                        showAgentVoList.add(showAgentVo);
                        showTicketVoList.add(showTicketVo);

                        totalShowTicketVo.setTotalPrice(totalShowTicketVo.getTotalPrice().add(showTicketVo.getTotalPrice()));
                        totalShowTicketVo.setAgentSaleNum(totalShowTicketVo.getAgentSaleNum().add(showTicketVo.getAgentSaleNum()));
                    }
                    showTicketVoList.add(totalShowTicketVo);
                } else {
                    return AjaxResult.warn("查询票提信息失败");
                }
            }

            getShowVo(showVoById, kylinPerformanceVo, showAgentVoList, showTicketVoList);

            return AjaxResult.success(showVoById);
        }
        return AjaxResult.warn("请重试");
    }

    private void getShowVo(ShowVoById showVoById, KylinPerformanceVo kylinPerformanceVo, List<ShowAgentVo> showAgentVoList, List<ShowTicketVo> showTicketVoList) {
        showVoById.setPerformancesId(kylinPerformanceVo.getPerformancesId());
        showVoById.setImgPoster(kylinPerformanceVo.getImgPoster());
        showVoById.setTitle(kylinPerformanceVo.getTitle());
        showVoById.setTimeStart(kylinPerformanceVo.getTimeStart());
        showVoById.setTimeEnd(kylinPerformanceVo.getTimeEnd());
        showVoById.setCityId(kylinPerformanceVo.getCityId());
        showVoById.setCityName(kylinPerformanceVo.getCityName());
        showVoById.setFieldId(kylinPerformanceVo.getFieldId());
        showVoById.setFieldName(kylinPerformanceVo.getFieldName());
        showVoById.setShowAgentVoList(showAgentVoList);
        showVoById.setShowTicketVoList(showTicketVoList);
        showVoById.setDetails(kylinPerformanceVo.getDetails());
    }

    @Override
    public SaleDataVo saleData(String performancesId) {
        SaleDataVo saleDataVo = new SaleDataVo();
        //演出id
        saleDataVo.setPerformancesId(performancesId);
        //设置演出状态
        saleDataVo.setPriceStatus(smileRedisUtils.getShowPriceId(performancesId));
        List<SmileAgent> smileAgents = getSmileAgentsByProId(performancesId);
        if (smileAgents == null) {
            return null;
        }
        //演出名称
        LambdaQueryWrapper<KylinPerformances> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KylinPerformances::getPerformancesId, performancesId);
        KylinPerformances kylinPerformances = kylinPerformancesMapper.selectOne(queryWrapper);
        //KylinPerformanceVo kylinPerformanceVo = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
        if (kylinPerformances == null) {
            return null;
        }
        saleDataVo.setTitle(kylinPerformances.getTitle());
        //map 票提id，票提信息
        Map<String, SmileAgent> tidMap = getSmileAgentMap(smileAgents);

        List<String> ticketsIdList = smileAgents.stream().map(SmileAgent::getTicketId).collect(Collectors.toList());

        List<ShowAgentVo> showAgentVoList = new ArrayList<>();
        //根据票提IDs查询票信息
        List<TicketAndStatusDao> ticketAndStatusDaoList = kylinTicketsMapper.selectTicketsByIds(ticketsIdList);
        for (TicketAndStatusDao ticketAndStatusDao : ticketAndStatusDaoList) {
            SmileAgent smileAgent = tidMap.get(ticketAndStatusDao.getTicketsId());
            ShowAgentVo showAgentVo = getShowAgentVo(performancesId, ticketAndStatusDao, smileAgent);
            showAgentVoList.add(showAgentVo);
        }

        //根据演出id查询出所有代理人的销售
        List<ShowBaseVoDto> showBaseVoList = smileAgentMapper.selectMapByPerId(performancesId);
        //根据代理id进行分组
        Map<String, List<ShowBaseVoDto>> stringListMap = showBaseVoList.stream().collect(Collectors.groupingBy(ShowBaseVoDto::getAgentId));
        //创建list长度定位分组数量
        List<UserData> userDataList = new ArrayList<>(stringListMap.size());
        //遍历分组
        for (Map.Entry<String, List<ShowBaseVoDto>> showMap : stringListMap.entrySet()) {
            String uid = showMap.getKey();
            //判断uid是否已打款
            Integer status = smileRedisUtils.getShowPriceUid(performancesId, showMap.getKey());
            if (status != null) {
                //已打款跳出循环,去打款表中获取打款记录
                LambdaQueryWrapper<SmilePrice> lambdaQueryWrapper = Wrappers.lambdaQuery(SmilePrice.class);
                lambdaQueryWrapper.eq(SmilePrice::getPerformancesId, performancesId);
                lambdaQueryWrapper.eq(SmilePrice::getDelTag, 0);
                lambdaQueryWrapper.eq(SmilePrice::getUid, showMap.getKey());
                SmilePrice smilePrice = smilePriceMapper.selectOne(lambdaQueryWrapper);
                if (smilePrice.getRecord()!=null&&!smilePrice.getRecord().equals("")){
                    UserData userData = JSON.parseObject(smilePrice.getRecord(), UserData.class);
                    userData.setPriceStatus(0);
                    userDataList.add(userData);
                    continue;
                }
            }

            UserData userData = UserData.getNew();
            List<ShowBaseVoDto> showBaseVoDtoList = showMap.getValue();
            List<UserDataAgentVo> userDataAgentVos = new ArrayList<>();
            //当前list不为null，遍历有数据，方便后期判断是否总代取uid
            ShowBaseVoDto baseVoDto = showBaseVoDtoList.get(0);
            //根据票提id分组 list数量小于等于票提数量
            Map<String, List<ShowBaseVoDto>> tidMapByUid = showBaseVoDtoList.stream().collect(Collectors.groupingBy(ShowBaseVoDto::getTid));
            //对票提进行遍历（总代没有售出而普代有售出）
            for (TicketAndStatusDao smileAgent : ticketAndStatusDaoList) {
                //为没个uid的没个票提id 塞数据
                UserDataAgentVo userDataAgentVo = UserDataAgentVo.getNew();
                //有且只有一条
                List<ShowBaseVoDto> showBaseVoDtoS = tidMapByUid.get(smileAgent.getTicketsId());
                //判断用户是否卖出该票提
                if (showBaseVoDtoS != null && showBaseVoDtoS.size() > 0) {
                    ShowBaseVoDto showBaseVoDto = showBaseVoDtoS.get(0);
                    userDataAgentVo.setTicketsId(showBaseVoDto.getTid());
                    userDataAgentVo.setTicketName(smileAgent.getTitle());
                    userDataAgentVo.setNumber(showBaseVoDto.getNumber());
                    userDataAgentVo.setPrice(showBaseVoDto.getPrice());
//                    userDataAgentVo.setAgent(showBaseVoDto.getUse());
                    userDataAgentVo.setCommission(showBaseVoDto.getTotalPrice().setScale(2, RoundingMode.HALF_UP));
                } else {
                    //没有买过
                    userDataAgentVo.setTicketsId(smileAgent.getTicketsId());
                    userDataAgentVo.setTicketName(smileAgent.getTitle());
                    userDataAgentVo.setNumber(new BigDecimal(0));
                    userDataAgentVo.setPrice(new BigDecimal(0));
//                    userDataAgentVo.setAgent(showBaseVoDto.getType() == 1 ? tidMap.get(smileAgent.getTicketsId()).getTotalCarry() : tidMap.get(smileAgent.getTicketsId()).getOrdCarry());
                    userDataAgentVo.setCommission(new BigDecimal("0.00"));
                }
                //判断是否为总代
                if (baseVoDto.getType() == 1) {
                    //是总代  //在原有的数据上新增加该用户下所有普代的提成
                    Map orgMap = smileAgentMapper.getUserOrgByPerIdAndUidAndAgentMaster(performancesId, baseVoDto.getAgentId(), smileAgent.getTicketsId());
                    if (orgMap != null) {
                        userDataAgentVo.setCommission((userDataAgentVo.getCommission().add((BigDecimal) orgMap.get("totalPrice"))).setScale(2, RoundingMode.HALF_UP));
                    }
                }
                userDataAgentVos.add(userDataAgentVo);
            }
            userData.setUid(showBaseVoDtoList.get(0).getAgentId());
            userData.setUsername(showBaseVoDtoList.get(0).getName());
            userData.setCityName(showBaseVoDtoList.get(0).getCity());
            userData.setType(showBaseVoDtoList.get(0).getType());
            userData.setDataAgentVos(userDataAgentVos);
            //设置打款状态
            userData.setPriceStatus(smileRedisUtils.getShowPriceUid(performancesId, showBaseVoDtoList.get(0).getAgentId()));
            userDataList.add(userData);
            //缓存用户redis记录 计算
            smileRedisUtils.setUserDataByUid(userData, performancesId);
        }

        /*List<SmileUser> smileUsers = smileUserMapper.getAllUidByPerId(performancesId);
        List<UserData> userDataList = new ArrayList<>(smileUsers.size());
        for (SmileUser smileUser : smileUsers) {
            UserData userData = getUserData(performancesId, smileUser, tidMap, ticketAndStatusDaoList);
            userDataList.add(userData);
        }*/
        saleDataVo.setUserDataList(userDataList);
        saleDataVo.setShowAgentVoList(showAgentVoList);
        return saleDataVo;
    }

    @Override
    public AjaxResult allPrice(SmilePriceParam smilePriceParam) {
        Integer showPriceId = smileRedisUtils.getShowPriceId(smilePriceParam.getPerformancesId());
        //查询演出状态
        AjaxResult showStatue = showStatue(smilePriceParam);
        if (showStatue != null) {
            return showStatue;
        }
        //判断打款标识
        if (smilePriceParam.getStatus().equals(showPriceId)) {
            return AjaxResult.warn("不可重复提交");
        }
        if (smilePriceParam.getStatus().equals(0)) {
            //打款
            smileRedisUtils.setShowPriceId(smilePriceParam.getPerformancesId());
        } else {
            //未打款
            smileRedisUtils.delShowPriceId(smilePriceParam.getPerformancesId());
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult updateRedis() {
        try {
            String perIds = (String) smileRedisUtils.get(SmileRedisConst.SMILE_SHOW);
            if (StringUtils.isNotBlank(perIds)) {
                List<String> list = new ArrayList<>(Arrays.asList(perIds.split(",")));
                smileRedisUtils.setShowIds(list);
            }
        } catch (Exception e) {
            log.error("updateRedis()");
        }
        ArrayList<String> showIds = (ArrayList<String>) smileRedisUtils.getShowIds().stream().distinct().collect(Collectors.toList());
        smileRedisUtils.setShowIds(showIds);
        return AjaxResult.success(showIds);
    }

    private UserData getUserData(String performancesId, SmileUser smileUser, Map<String, SmileAgent> tidMap, List<TicketAndStatusDao> smileAgentList) {
        UserData userData = new UserData();
        //个人用户的演出数据详情
        //便利票种id 查询用户的销售数据信息
        List<UserDataAgentVo> userDataAgentVos = new ArrayList<>();
        for (TicketAndStatusDao smileAgent : smileAgentList) {
            UserDataAgentVo userDataAgentVo = new UserDataAgentVo();
            Map userMap = smileAgentMapper.getUserDataByPerIdAndTicketsId(performancesId, smileUser.getUid(), smileAgent.getTicketsId());
            if (userMap != null) {
                userDataAgentVo.setTicketsId((String) userMap.get("tid"));
                userDataAgentVo.setTicketName((String) userMap.get("title"));
                userDataAgentVo.setNumber((BigDecimal) userMap.get("num"));
                userDataAgentVo.setPrice((BigDecimal) userMap.get("price"));
                userDataAgentVo.setAgent((BigDecimal) userMap.get("use"));
                userDataAgentVo.setCommission(((BigDecimal) userMap.get("totalPrice")).setScale(2, RoundingMode.HALF_UP));
            } else {
                userDataAgentVo.setTicketsId(smileAgent.getTicketsId());
                userDataAgentVo.setTicketName(smileAgent.getTitle());
                userDataAgentVo.setNumber(new BigDecimal(0));
                userDataAgentVo.setPrice(new BigDecimal(0));
                userDataAgentVo.setAgent(smileUser.getType() == 1 ? tidMap.get(smileAgent.getTicketsId()).getTotalCarry() : tidMap.get(smileAgent.getTicketsId()).getOrdCarry());
                userDataAgentVo.setCommission(new BigDecimal("0.00"));
                log.debug("saleData：演出id:{},用户id:{},票提id:{}", performancesId, smileUser.getUid(), smileAgent.getTicketsId());
            }
            //判断该用户是否是总代理
            if (smileUser.getType() == 1) {
                //是总代  //在原有的数据上新增加该用户下所有普代的提成
                Map orgMap = smileAgentMapper.getUserOrgByPerIdAndUidAndAgentMaster(performancesId, smileUser.getUid(), smileAgent.getTicketsId());
                if (orgMap != null) {
                    userDataAgentVo.setCommission((userDataAgentVo.getCommission().add((BigDecimal) orgMap.get("totalPrice"))).setScale(2, RoundingMode.HALF_UP));
                } else {
                    log.debug("saleData：演出id:{},用户id:{},票提id:{}", performancesId, smileUser.getUid(), smileAgent.getTicketsId());
                }
            }
//            if (userDataAgentVo.getCommission().compareTo(new BigDecimal(0)) != 0) {
            userDataAgentVos.add(userDataAgentVo);
//            }
        }
        userData.setUid(smileUser.getUid());
        userData.setUsername(smileUser.getName());
        userData.setCityName(smileUser.getCity());
        userData.setType(smileUser.getType());
        userData.setDataAgentVos(userDataAgentVos);
        //设置打款状态
        userData.setPriceStatus(smileRedisUtils.getShowPriceUid(performancesId, smileUser.getUid()));
        return userData;
    }

    private Map<String, SmileAgent> getSmileAgentMap(List<SmileAgent> smileAgents) {
        Map<String, SmileAgent> map = new HashMap<>(smileAgents.size());
        smileAgents.forEach(smileAgent -> map.put(smileAgent.getTicketId(), smileAgent));
        return map;
    }

    private List<SmileAgent> getSmileAgentsByProId(String performancesId) {
        LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
        queryWrapper.eq(SmileAgent::getPerformanceId, performancesId);
        queryWrapper.eq(SmileAgent::getDelTag, 0);
        return smileAgentMapper.selectList(queryWrapper);
    }

    private ShowAgentVo getShowAgentVo(String performancesId, TicketAndStatusDao ticketAndStatusDao, SmileAgent smileAgent) {
        ShowAgentVo showAgentVo = new ShowAgentVo();
        showAgentVo.setId(ticketAndStatusDao.getMid());
        showAgentVo.setPerformanceId(performancesId);
        showAgentVo.setTicketId(ticketAndStatusDao.getTicketsId());
        showAgentVo.setTitle(ticketAndStatusDao.getTitle());
        //开始结束时间转换年月日
        String start = ticketAndStatusDao.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String end = ticketAndStatusDao.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if (start.equals(end)) {
            showAgentVo.setTitle(ticketAndStatusDao.getTitle().concat("(").concat(start).concat(")"));
        } else {
            showAgentVo.setTitle(ticketAndStatusDao.getTitle().concat("(").concat(start).concat("--").concat(end).concat(")"));
        }
        //总代票提
        showAgentVo.setTotalCarry(smileAgent.getTotalCarry());
        //普代票提
        showAgentVo.setOrdCarry(smileAgent.getOrdCarry());
        return showAgentVo;
    }

    @Override
    public void exportData(ServletOutputStream servletOutputStream, String performancesId) {
        ExcelWriter writer = EasyExcelFactory.write(servletOutputStream).build();
        // 动态添加表头，适用一些表头动态变化的场景
        SaleDataVo saleDataVo = saleData(performancesId);
        WriteSheet sheet1 = new WriteSheet();
        sheet1.setSheetName(saleDataVo.getTitle().concat("演出数据"));
        sheet1.setSheetNo(0);

        List<UserData> userDataList = saleDataVo.getUserDataList();
        ArrayList<String> ticketList = Lists.newArrayList();
        List<ShowAgentVo> agentVoList = saleDataVo.getShowAgentVoList();
        agentVoList.forEach(showAgentVo -> ticketList.add(showAgentVo.getTitle()));
        // 创建一个表格，用于 Sheet 中使用
        WriteTable table = new WriteTable();
        table.setTableNo(1);
        table.setHead(head(ticketList));
        // 写数据
        if (userDataList != null) {
            writer.write(contentData(userDataList, agentVoList), sheet1, table);
        }
        writer.finish();
    }

    private List<List<String>> head(List<String> ticketList) {
        List<List<String>> headTitles = new ArrayList<>();
        String basicInfo = "代理数据";
        String ticket = "票数据";
        String saleData = "销售数据";
        headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "uid"));
        headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "姓名"));
       /* headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "性别"));
        headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "手机号"));*/
        headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "所属地区"));
        headTitles.add(Lists.newArrayList(basicInfo, basicInfo, "身份"));

        //做表
        ticketList.forEach(title -> headTitles.add(Lists.newArrayList(ticket, ticket, title)));
        ArrayList<String> dataList = Lists.newArrayList("总销售张数", "总销售金额", "总销售佣金", "打款状态");
        //做表
        dataList.forEach(dataStr -> headTitles.add(Lists.newArrayList(saleData, saleData, dataStr)));

        return headTitles;
    }

    private List<List<Object>> contentData(List<UserData> userDataList, List<ShowAgentVo> agentVoList) {
        List<List<Object>> contentList = Lists.newArrayList();
        //这里一个List<Object>才代表一行数据，需要映射成每行数据填充，横向填充（把实体数据的字段设置成一个List<Object>）
//        contentList.add(Lists.newArrayList("测试", "商品A", "苹果🍎"));
        userDataList.forEach(userData -> {
            //总销售张数
            BigDecimal num = new BigDecimal("0");
            //总销售金额
            BigDecimal price = new BigDecimal("0");
            //总销售佣金
            BigDecimal commission = new BigDecimal("0");

            ArrayList<Object> arrayList = Lists.newArrayList();
            arrayList.add(userData.getUid());
            arrayList.add(userData.getUsername());
            arrayList.add(userData.getCityName());
            arrayList.add(userData.getType() == 1 ? "总代" : "普代");

            //便利票数据
            List<UserDataAgentVo> dataAgentVos = userData.getDataAgentVos();
            Map<String, UserDataAgentVo> agentVoMap = dataAgentVos.stream().collect(Collectors.toMap(UserDataAgentVo::getTicketsId, Function.identity()));
            //遍历agentVoList顺序塞值
            for (ShowAgentVo showAgentVo : agentVoList) {
                UserDataAgentVo userDataAgentVo = agentVoMap.get(showAgentVo.getTicketId());
                if (userDataAgentVo != null) {
                    num = num.add(new BigDecimal(userDataAgentVo.getNumber().toString()));
                    price = price.add(userDataAgentVo.getPrice().multiply(userDataAgentVo.getNumber()));
                    commission = commission.add(userDataAgentVo.getCommission());
                    arrayList.add(userDataAgentVo.getNumber());
                } else {
                    arrayList.add(0);
                }
            }

           /* for (UserDataAgentVo userDataAgentVo : dataAgentVos) {
                num = num.add(new BigDecimal(userDataAgentVo.getNumber().toString()));
                price = price.add(userDataAgentVo.getPrice().multiply(userDataAgentVo.getNumber()));
                commission = commission.add(userDataAgentVo.getCommission());
                arrayList.add(userDataAgentVo.getNumber());
            }*/

            arrayList.add(num);
            arrayList.add(price);
            arrayList.add(commission);
            arrayList.add(userData.getPriceStatus() != null && userData.getPriceStatus() == 0 ? "已打款" : "待打款");

            contentList.add(arrayList);
        });
        return contentList;
    }

}
