package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreConfigVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreErpConfigVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.enums.GoblinStoreConf;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class GoblinStoreMgtServiceImpl implements IGoblinStoreMgtService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public boolean updateStoreMgtInfo(GoblinStoreInfoVo storeInfoVo) {
        if (goblinMongoUtils.updateStoreInfoVo(storeInfoVo)) {
            goblinRedisUtils.delStoreInfoVo(storeInfoVo.getStoreId());

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_store_info.update_by_edit",
                            storeInfoVo.getStoreName(), storeInfoVo.getLogoPic(), storeInfoVo.getBackgroundPic(), storeInfoVo.getIntroduce(),
                            storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId()
                    ));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateStoreMgtConfig(String uid, String storeId, Map<String, String> confMap) {
        LocalDateTime now = LocalDateTime.now();
        List<GoblinStoreConfigVo> storeConfigVos = goblinRedisUtils.getStoreConfigVos(storeId);
        log.info("店铺管理:店铺设置:编辑[UID={},storeId={},BEF={}]", uid, storeId, JsonUtils.toJson(confMap));
        List<GoblinStoreConfigVo> updateStoreConfigVoList = ObjectUtil.getGoblinStoreConfigVoArrayList();
        boolean toUpdateStoreStatusFlg = false;
        for (GoblinStoreConfigVo configVo : storeConfigVos) {
            String updateConfVal = confMap.get(configVo.getConfigKey());
            if (configVo.getConfigKey().equals(GoblinStoreConf.BUSINESS_STATUS.name())) {
                toUpdateStoreStatusFlg = !configVo.getConfigVal().equals(updateConfVal);
            }
            if (StringUtils.isNotEmpty(updateConfVal)) {
                configVo.setConfigVal(updateConfVal);
                configVo.setUpdatedBy(uid);
                configVo.setUpdatedAt(now);
                updateStoreConfigVoList.add(configVo);
            }
        }
        if (!CollectionUtils.isEmpty(updateStoreConfigVoList) && goblinMongoUtils.updateStoreConfigVos(updateStoreConfigVoList)) {
            log.info("店铺管理:店铺设置:编辑[UID={},storeId={},AFT={}]", uid, storeId, JsonUtils.toJson(confMap));
            goblinRedisUtils.delStoreConfigVos(storeId);

            LinkedList<Object[]> updateStoreInfoObjs = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> updateGoodsInfoObjs = CollectionUtil.linkedListObjectArr();
            if (toUpdateStoreStatusFlg) {
                String status = confMap.get(GoblinStoreConf.BUSINESS_STATUS.name());

                GoblinStoreInfoVo updateStoreInfoVo = goblinRedisUtils.getStoreInfoVo(storeId);
                updateStoreInfoVo.setStatus(status);
                updateStoreInfoVo.setUpdatedBy(uid);
                updateStoreInfoVo.setUpdatedAt(now);
                goblinMongoUtils.updateStoreInfoVo(updateStoreInfoVo);
                goblinRedisUtils.delStoreInfoVo(storeId);

                goblinMongoUtils.updateGoodsInfoVoAppear(storeId, status.equals("4") ? "1" : "0", now, uid);

                goblinRedisUtils.deleteKeyForSelectGoods();// 精选商品:商品上架、下架、删除 调用的方法

                List<String> spuIdList = goblinMongoUtils.getMgtGoodsSpuIds(storeId);
                spuIdList.forEach(spuId -> goblinRedisUtils.delGoodsInfoVo(spuId));

                updateStoreInfoObjs.add(new Object[]{updateStoreInfoVo.getStatus(), uid, now, storeId});
                updateGoodsInfoObjs.add(new Object[]{status.equals("4") ? "1" : "0", uid, now, storeId});
            }

            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            toMqSqls.add(SqlMapping.get("goblin_store_config.update"));
            LinkedList<Object[]> updateStoreConfigVoObjs = CollectionUtil.linkedListObjectArr();
            updateStoreConfigVoList.forEach(uc -> updateStoreConfigVoObjs.add(new Object[]{
                    uc.getConfigVal(), uc.getUpdatedBy(), uc.getUpdatedAt(), uc.getStoreId(), uc.getConfigKey()}));
            toMqSqls.add(SqlMapping.get("goblin_store_info.update_by_setting"));
//            LinkedList<Object[]> updateStoreInfoObjs = CollectionUtil.linkedListObjectArr();
            toMqSqls.add(SqlMapping.get("goblin_goods.update_by_status"));
//            LinkedList<Object[]> updateGoodsInfoObjs = CollectionUtil.linkedListObjectArr();

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.gets(toMqSqls, updateStoreConfigVoObjs, updateStoreInfoObjs, updateGoodsInfoObjs));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateStoreMgtErpConfig(String uid, GoblinStoreErpConfigVo storeErpConfigVo) {
        if (goblinMongoUtils.updateStoreErpConfigVo(storeErpConfigVo)) {
            goblinRedisUtils.delStoreErpConfigVo(storeErpConfigVo.getStoreId());

            // TODO: 2023/1/6 zhanggb to Mysql
            return true;
        }
        return false;
    }
}
