package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinServiceSupportVo", description = "服务保障信息")
@Data
public class GoblinServiceSupportVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -6408263563025607959L;
    @ApiModelProperty(position = 10, value = "服务支持ID[30]")
    private String ssid;
    @ApiModelProperty(position = 11, value = "服务支持名称[50]")
    private String name;
    @ApiModelProperty(position = 12, value = "服务支持描述[256]")
    private String desc;
    @ApiModelProperty(position = 13, value = "服务支持图片地址[256]")
    private String url;

    private static final GoblinServiceSupportVo obj = new GoblinServiceSupportVo();
    public static GoblinServiceSupportVo getNew() {
        try {
            return (GoblinServiceSupportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinServiceSupportVo();
        }
    }
}
