package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftGoodsSkuListVo", description = "NFT商品SKU信息列表使用")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 16, value = "是否盲盒[0-否|1-是]")
    private String unbox;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 28, value = "创建时间")
    private LocalDateTime createdAt;


    @ApiModelProperty(position = 55, value = "spu相关信息")
    private GoblinNftGoodsSpuInfoVo goblinNftGoodsSpuInfoVo;

    @ApiModelProperty(position = 56, value = "是否售罄[0-否|1-是] 服务端判断库存使用")
    private String soldoutStatus;
    @ApiModelProperty(position = 57, value = "是否还有库存 0没有库存即售罄 1有库存")
    private int isStock;

    @ApiModelProperty(position = 59, value = "当前用户还可以购买数量 有限购的时候用")
    private String aboutStartDate;
    @ApiModelProperty(position = 60, value = "当前用户还可以购买数量 有限购的时候用")
    private String aboutEndDate;
    @ApiModelProperty(position = 61, value = "预约状态(0:未开始，1:可预约，3:已结束)")
    private Integer state;
    @ApiModelProperty(position = 62, value = "标签[0-提前购买|1-分段购买]")
    private Integer tagType;
    @ApiModelProperty(position = 63, value = "NFT路由[zxinchain-至信链|xuper-百度超级链]")
    private String routeType;
    @ApiModelProperty(position = 64, value = "转赠时间[单位秒]")
    private Long transferTimeLimit;
    @ApiModelProperty(position = 65, value = "是否可转债[0-否|1-是]")
    private Integer transferable;

    private static final GoblinNftGoodsSkuListVo obj = new GoblinNftGoodsSkuListVo();

    public static GoblinNftGoodsSkuListVo getNew() {
        try {
            return (GoblinNftGoodsSkuListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSkuListVo();
        }
    }

    public GoblinNftGoodsSkuListVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuPic(source.getSkuPic());
        this.setSaleStartTime(source.getSaleStartTime());
        this.setSoldoutStatus(source.getSoldoutStatus());
        this.setUnbox(source.getUnbox());
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }

    public GoblinNftGoodsSkuListVo setAnticipateValueVo(AnticipateValueVo anticipateValueVo) {
        if (anticipateValueVo != null) {
            if (anticipateValueVo.getAboutEndDate() != null) {
                this.setAboutEndDate(DateUtil.Formatter.yyyyMMddHHmmss.format(anticipateValueVo.getAboutEndDate()));
            }
            if (anticipateValueVo.getAboutEndDate() != null) {
                this.setAboutStartDate(DateUtil.Formatter.yyyyMMddHHmmss.format(anticipateValueVo.getAboutStartDate()));
            }
            if (anticipateValueVo.getState() != null) {
                this.setState(anticipateValueVo.getState());
            }
        }
        return this;
    }
}
