package com.liquidnet.service.platform.service.express.shunfeng;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderExpress;
import com.liquidnet.service.platform.utils.ShunfengSignUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressCallbackServiceImpl extends ServiceImpl<KylinOrderExpressMapper, KylinOrderExpress> implements IKylinOrderExpress {

    @Value("${liquidnet.shunfeng.custid}")
    private String custid;
    @Value("${liquidnet.shunfeng.jCompany}")
    private String jCompany;
    @Value("${liquidnet.shunfeng.jContact}")
    private String jContact;
    @Value("${liquidnet.shunfeng.jTel}")
    private String jTel;
    @Value("${liquidnet.shunfeng.jProvince}")
    private String jProvince;
    @Value("${liquidnet.shunfeng.jCity}")
    private String jCity;
    @Value("${liquidnet.shunfeng.jAddress}")
    private String jAddress;
    @Value("${liquidnet.shunfeng.expressType}")
    private Integer expressType;
    @Value("${liquidnet.shunfeng.depositumInfo}")
    private String depositumInfo;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private ShunfengSignUtils shunfengSignUtils;

    @Autowired
    private KylinOrderExpressMapper kylinOrderExpressMapper;

    @Autowired
    private KylinOrderExpressFeeInfoMapper kylinOrderExpressFeeInfoMapper;

    @Autowired
    private KylinOrderExpressRouteMapper kylinOrderExpressRouteMapper;

    @Autowired
    HttpServletRequest httpServletRequest;

    public boolean orderStatus(PerformanceExpressPushStatusParam performanceExpressPushStatusParam) {

        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(JsonUtils.toJson(performanceExpressPushStatusParam), httpServletRequest);
        System.out.println(performanceExpressPushStatusParam);
        System.out.println(res);

        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = httpServletRequest.getHeader(key);
            System.out.println(key + "=" + value);
        }

        return false;
    }

    public boolean orderFreightList(PerformanceExpressPushFreightParam performanceExpressPushFreightParam) {

        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(JsonUtils.toJson(performanceExpressPushFreightParam), httpServletRequest);
        System.out.println(performanceExpressPushFreightParam);
        System.out.println(res);

        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = httpServletRequest.getHeader(key);
            System.out.println(key + "=" + value);
        }
        /*KylinOrderExpressFeeInfo kylinOrderExpressFeeInfo = new KylinOrderExpressFeeInfo();
        String orderExpressFeeInfoId = IDGenerator.nextSnowId();
        kylinOrderExpressFeeInfo.setOrderExpressFeeInfoId(orderExpressFeeInfoId);
        kylinOrderExpressFeeInfo.setOrderExpressId(orderExpressInfo.getOrderExpressId());
        kylinOrderExpressFeeInfo.setType((String) feeInfo.get("type"));
        kylinOrderExpressFeeInfo.setName((String) feeInfo.get("name"));
        kylinOrderExpressFeeInfo.setValue(new BigDecimal(feeInfo.get("value").toString()));
        kylinOrderExpressFeeInfo.setCreatedAt(DateUtil.getNowTime());
        kylinOrderExpressFeeInfoMapper.insert(kylinOrderExpressFeeInfo);*/

        return false;
    }

    public boolean orderRoute(PerformanceExpressPushRouteParam performanceExpressPushRouteParam) {

        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(JsonUtils.toJson(performanceExpressPushRouteParam), httpServletRequest);
        System.out.println(performanceExpressPushRouteParam);
        System.out.println(res);

        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = httpServletRequest.getHeader(key);
            System.out.println(key + "=" + value);
        }
        /*KylinOrderExpressRoute kylinOrderExpressRoute = new KylinOrderExpressRoute();
        String orderExpressRouteId = IDGenerator.nextSnowId();
        kylinOrderExpressRoute.setOrderExpressRouteId(orderExpressRouteId);
        kylinOrderExpressRoute.setOrderExpressId(orderExpressInfo.getOrderExpressId());
        kylinOrderExpressRoute.setAcceptAddress((String) routeInfo.get("accept_address"));
        kylinOrderExpressRoute.setAcceptDate((String) routeInfo.get("accept_date"));
        kylinOrderExpressRoute.setAcceptTime((String) routeInfo.get("accept_time"));
        kylinOrderExpressRoute.setAcceptTotaltime((String) routeInfo.get("accept_totaltime"));
        kylinOrderExpressRoute.setRemark((String) routeInfo.get("remark"));
        kylinOrderExpressRoute.setOpcode((String) routeInfo.get("opcode"));
        kylinOrderExpressRoute.setCreatedAt(DateUtil.getNowTime());
        kylinOrderExpressRouteMapper.insert(kylinOrderExpressRoute);*/

        return false;
    }

}