package com.liquidnet.service.slime.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场地表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SlimeFields implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * field_id
     */
    private String fieldId;

    /**
     * 上线状态 0下线 1上线
     */
    private Integer isOnline;

    /**
     * 认领状态 0未认领 1已认领 2认领中
     */
    private Integer claimStatus;

    /**
     * 场地所有者账号
     */
    private String uid;

    /**
     * 审核演出开关 0不审 1审核
     */
    private Integer isCheck;

    /**
     * 名称
     */
    private String name;

    /**
     * logo图片地址
     */
    private String logo;

    /**
     * 背景图片地址
     */
    private String background;

    /**
     * 介绍
     */
    private String description;

    /**
     * 建立日期
     */
    private LocalDate builtDate;

    /**
     * 省份ID
     */
    private String provinceId;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市ID
     */
    private String cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 区县ID
     */
    private String districtId;

    /**
     * 区县名称
     */
    private String districtName;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系人邮箱
     */
    private String contactEmail;

    /**
     * 企业信息ID
     */
    private String companyId;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
