package com.liquidnet.service.adam.constant;

/**
 * 订单
 */
public class AdamMemberOrderConst {
    // 订单状态
    public static final Integer STATUS_UNPAID = 0;   // 待支付
    public static final Integer STATUS_PAID = 1;    //  已支付
    public static final Integer STATUS_EXPIRED = 2; //  已过期（限时10分钟支付，20分钟回滚卡号，变更为已过期）
    public static final Integer STATUS_LATE = 3;    // 超时付（超过20分钟支付，此时卡号已回滚）
    public static final Integer STATUS_REFUNDING = 4; // 退款中
    public static final Integer STATUS_REFUND = 5;    // 退款完成

    public static final String TYPE_BUY = "buy";  // 购买会员、会员码
    public static final String TYPE_CODE = "code";  // 使用会员码

    public static final String TYPE_VIP = "VIP";
    public static final String TYPE_CLUB = "CLUB";

    public static final Integer TIME_LIMIT = 5;
    public static final Integer TIME_OUT = 10;

    public static final Integer SUB_TYPE_BUY_VIP = 0;
    public static final Integer SUB_TYPE_BUY_VIP_CODE = 1;    // 购买会员码（不需要填写地址）
    public static final Integer SUB_TYPE_USE_VIP_CODE = 2;    // 使用会员码（购买的）（仅限从未购买过会员的用户使用，需要填写地址）
    public static final Integer SUB_TYPE_USE_GIFT_CODE = 3;    // 使用会员码（赠送的）（仅限从未购买过会员的用户使用，不需要填写地址）

    // 用户会员状态
    public static final Integer STATE_VALID = 1;  //  正常
    public static final Integer STATE_EXPIRED = 2;  //  已失效


}
