package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.merchant.entity.MerchantSponsorApplies;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "MerchantStationsVo", description = "小站")
@Data
public class MerchantStationsVo {

    @ApiModelProperty(position = 10, value = "申请类型 field-场地、sponsor-主办")
    private String stationType;

    @ApiModelProperty(position = 11, value = "申请场地vo")
    private MerchantFieldAppliesVo fieldAppliesVo;

    @ApiModelProperty(position = 12, value = "申请主办vo")
    private MerchantSponsorAppliesVo sponsorAppliesVo;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;


    private static final MerchantStationsVo obj = new MerchantStationsVo();

    public static MerchantStationsVo getNew() {
        try {
            return (MerchantStationsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantStationsVo();
    }
}
