package com.liquidnet.service.erp.constant;

public class ErpEnum {
    /**
     * ERP类型
     */
    public enum ErpType {
        /**
         * 旺店通
         */
        WANGDIAN,
    }

    /**
     * 旺店通API
     * https://open.wangdian.cn/open/apidoc
     */
    public enum WdtAPI {
        /**
         * 增量查询库存
         */
        STOCK_QUERY("stock_query.php"),
        /**
         * 创建原始订单
         * 建议每间隔（5~10）分钟，将商城积累的订单集中推送，每次请求包含订单条数建议不超过50条(1条订单由“trade_list+order_list”构成)，如果累积量超过了50条，分多次请求。
         */
        TRADE_PUSH("trade_push.php"),
        /**
         * 查询物流同步
         * 查询后需要调用 logistics_sync_ack 应答
         */
        LOGISTICS_SYNC_QUERY("logistics_sync_query.php"),
        /**
         * 物流同步回写
         * 查询后需要调用 logistics_sync_ack 应答
         */
        LOGISTICS_SYNC_ACK("logistics_sync_ack.php"),
//        /**
//         * 查询库存同步
//         * 建议间隔时间3~5分钟查询一次，集中获取待同步数据，注意上一次回写完成以后，再从数据池获取待同步的数据。 查询后需要调用 api_goods_stock_change_ack 应答
//         */
//        API_GOODS_STOCK_CHANGE_QUERY("api_goods_stock_change_query.php"),
//        /**
//         * 库存同步回写
//         * 查询后需要调用 api_goods_stock_change_ack 应答
//         */
//        API_GOODS_STOCK_CHANGE_ACK("api_goods_stock_change_ack.php"),
        /**
         * 创建原始退款单
         * 销售订单（包括发货前和发货后）退款或退货单据推送至ERP。注：销售订单的售后换货订单此接口推送“退货类型”退款单，换出订单“trade_push.php”推送
         * 批量推送的退款单据，每次不超过10单
         */
//        API_SALES_REFUND_PUSH("sales_refund_push.php"),
        /**
         * 查询退换管理
         * 获取ERP销售退货（换货）订单信息
         * 按照旺店通ERP订单的最后修改时间增量获取数据，请求时输入start_time和end_time作为时间跨度的筛选条件。
         */
//        API_REFUND_QUERY("refund_query.php");
        ;
        private final String uri;

        WdtAPI(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return uri;
        }
    }

    public enum WdtStatus {
        /**
         * 增量查询库存
         */
        //未确认，客户只拍单未未付款(等待付款的订单,货到付款（COD）订单不需要等付款，直接进行待发货)
        STATUS_UN_PAY(10),
        //        STATUS_(20),
        //已付款待发货(包含货到付款)，30只可以直接变更为70/ 80这2种状态
        STATUS_UN_SEND(30),
        //        STATUS_(40),
        //已发货(平台销售订单已经发货时推送此状态)，如果已发货在自建商城代表订单完结状态，无后续状态变更，直接推送状态值70
        STATUS_SEND(50),
        //已完成（已签收），平台订单完成（客户确认收货）后，推送此状态;
        //订单为自动流转模式时，初次推送的平台订单状态直接就是已完成状态70
        STATUS_FINISH(70),
        //已退款(付款后又全部退款推送此状态)
        STATUS_REFUND(80),
        //已关闭(未付款直接取消的订单推送此状态)
        STATUS_CLOSE(90);

        private final int status;

        WdtStatus(int status) {
            this.status = status;
        }

        public int WdtStatus() {
            return status;
        }
    }
}
