package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontCubeService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinFrontCube;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinFrontCubeMapper;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontCubeParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-07
 */
@Service
public class GoblinFrontCubeServiceImpl extends ServiceImpl<GoblinFrontCubeMapper, GoblinFrontCube> implements IGoblinFrontCubeService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontCubeMapper goblinFrontCubeMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;

    public boolean create(GoblinFrontCube goblinFrontCube){
        goblinFrontCube.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontCube.setCubeId(IDGenerator.nextSnowId());
        //增加 banner
        goblinFrontCubeMapper.insert(goblinFrontCube);
        return true;
    }

    public boolean updateOrCreate(GoblinFrontCube goblinFrontCube) {
        if (goblinFrontCube.getMid() == 0) {
            this.create(goblinFrontCube);
        } else {
            goblinFrontCube.setUpdateTime(LocalDateTime.now());
            //数据库修改
            goblinFrontCubeMapper.updateById(goblinFrontCube);
        }
        return true;
    }
    public List<GoblinFrontCubeParam> listGoblinFrontCubeParam(){
        LambdaQueryWrapper<GoblinFrontCube> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCube.class);
        queryWrapper.ne(GoblinFrontCube::getDelTag,1);
        List<GoblinFrontCube> list=goblinFrontCubeMapper.selectList(queryWrapper);
        List<GoblinFrontCubeParam> list1=new ArrayList<>();
        for(GoblinFrontCube goblinFrontCube:list){
            //找到  spu详情
            LambdaQueryWrapper<GoblinGoods> queryWrappers = Wrappers.lambdaQuery(GoblinGoods.class);
            queryWrappers.ne(GoblinGoods::getDelFlg,"1");
            queryWrappers.eq(GoblinGoods::getSpuId,goblinFrontCube.getSpuId());
            List<GoblinGoods> goodsList= goblinGoodsMapper.selectList(queryWrappers);
            GoblinFrontCubeParam goblinFrontCubeParam=new GoblinFrontCubeParam();
            BeanUtils.copyProperties(goblinFrontCube,goblinFrontCubeParam);
            goblinFrontCubeParam.setGoblinGoods(goodsList.get(0));
            list1.add(goblinFrontCubeParam);
        }
        return list1;
    }


}
