package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsSpecValueVo", description = "商品规格值信息")
@Data
public class GoblinGoodsSpecValueVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 8201082385017215765L;
    @ApiModelProperty(position = 11, value = "规格值的名称")
    private String specVname;
    @ApiModelProperty(position = 12, value = "排序[数值越小排序越前]")
    private int specVsort;

    public GoblinGoodsSpecValueVo setSpecVname(String specVname) {
        this.specVname = specVname;
        return this;
    }

    public GoblinGoodsSpecValueVo setSpecVsort(int specVsort) {
        this.specVsort = specVsort;
        return this;
    }

    private static final GoblinGoodsSpecValueVo obj = new GoblinGoodsSpecValueVo();
    public static GoblinGoodsSpecValueVo getNew() {
        try {
            return (GoblinGoodsSpecValueVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSpecValueVo();
        }
    }
}
