package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.service.goblin.entity.GoblinSelfGoodsCategory;
import com.liquidnet.service.goblin.entity.GoblinStoreInfo;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("goblin/category")
public class GoblinSelfCategoryController extends BaseController {
    private final String prefix = "zhengzai/goblin/category";

    @GetMapping()
    public String category() {
        return prefix.concat("/category");
    }

    @RequiresPermissions("goblin:category:list")
    @RequestMapping("/list")
    @ResponseBody
    public TableDataInfo list(GoblinStoreInfo storeInfo) {
        LambdaQueryWrapper<GoblinSelfGoodsCategory> lambdaQueryWrapper = Wrappers.lambdaQuery(GoblinSelfGoodsCategory.class);
        lambdaQueryWrapper.eq(GoblinSelfGoodsCategory::getDelFlg, "0");
        PageHelper.startPage(0, 1000, "mid desc");
        return getDataTable(null);
    }
}
