drop schema if exists ln_kylin;
create database ln_kylin character set utf8mb4 collate utf8mb4_unicode_ci;
-- >>------------------------------------------------------------------------------------
use `ln_kylin`;

SET NAMES utf8mb4;
-- 轮播图
drop TABLE if exists `kylin_banners`;
CREATE TABLE `kylin_banners`
(
    `mid`               int          NOT NULL AUTO_INCREMENT,
    `banners_id`        varchar(255) NOT NULL DEFAULT ''   COMMENT 'banners_id',
    `banners_name`      varchar(255) NOT NULL DEFAULT ''   COMMENT '标题',
    `cover_img`         varchar(255) NOT NULL DEFAULT ''   COMMENT '封面图',
    `target_type`       smallint     NOT NULL DEFAULT 0    COMMENT '跳转类型(由接口提供)',
    `target_obj`        varchar(255) NOT NULL DEFAULT ''   COMMENT '跳转目标 id/url等',
    `is_online`         tinyint      NOT NULL DEFAULT 0    COMMENT '是否上线展示 0下线 1上线',
    `online_start_time` timestamp    NULL     DEFAULT NULL COMMENT '上线开始时间',
    `online_end_time`   timestamp    NULL     DEFAULT NULL COMMENT '上线结束时间',
    `promotion_type`    tinyint      NOT NULL DEFAULT 1    COMMENT '推广类型 1全国 2省份',
    `banners_sort`      int          NOT NULL DEFAULT 0    COMMENT '排序 越大越靠前',
    `remarks`           varchar(255) NOT NULL DEFAULT ''   COMMENT '备注',
    `is_deleted`        tinyint      NOT NULL DEFAULT 1    COMMENT '是否删除 0已删除 1正常',
    `created_at`        datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`        datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_banners_banners_id_index` (`banners_id`),
    KEY `kylin_banners_banners_name_index` (`banners_name`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '轮播图';

drop TABLE if exists `kylin_banners_relations`;
CREATE TABLE `kylin_banners_relations`
(
    `mid`           int          NOT NULL AUTO_INCREMENT,
    `banners_relations_id`    varchar(255) NOT NULL DEFAULT ''   COMMENT 'banners_relations_id',
    `banners_id`    varchar(255) NOT NULL DEFAULT ''   COMMENT 'banners_id',
    `field_id`      int          NOT NULL DEFAULT 0    COMMENT '展示位置id/推广省份code',
    `field_id_type` tinyint      NOT NULL DEFAULT 1    COMMENT '关联字段类型 1展示位置(由接口提供) 2推广省份(由接口提供)',
    `created_at`    datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_banners_relations_banners_relations_id_index` (`banners_relations_id`),
    KEY `kylin_banners_relations_banners_id_index` (`banners_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '轮播图 展示位置/推广省份 关联表';

-- 场地
drop TABLE if exists `kylin_fields`;
CREATE TABLE `kylin_fields`
(
    `mid`            int(11)      NOT NULL AUTO_INCREMENT,
    `fields_id`      varchar(255) NOT NULL DEFAULT '' COMMENT 'fields_id',
    `name`           varchar(255) NOT NULL DEFAULT '' COMMENT '场地名称',
    `name_eng`       varchar(255) NOT NULL DEFAULT '' COMMENT '英文名',
    `pinyin`         varchar(255) NOT NULL DEFAULT '' COMMENT '拼音',
    `cover_img`      varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
    `address`        varchar(255) NOT NULL DEFAULT '' COMMENT '详细地址',
    `longitude`      varchar(255) NOT NULL DEFAULT '' COMMENT '经度',
    `latitude`       varchar(255) NOT NULL DEFAULT '' COMMENT '维度',
    `phone`          varchar(255) NOT NULL DEFAULT '' COMMENT '联系电话',
    `description`    varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
    `province_id`    int(255)     NOT NULL DEFAULT 0 COMMENT '省id',
    `province_name`  varchar(255) NOT NULL DEFAULT '' COMMENT '省名称',
    `city_id`        int(11)      NOT NULL DEFAULT 0 COMMENT '城市id',
    `city_name`      varchar(255) NOT NULL DEFAULT '' COMMENT '城市名称',
    `district_id`    int(11)      NOT NULL DEFAULT 0 COMMENT '县id',
    `district_name`  varchar(255) NOT NULL DEFAULT '' COMMENT '县名称',
    `refuse_message` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝理由',
    `comment`        varchar(255) NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`     datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`     datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_fields_uid_index` (`fields_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '场地数据';
-- 场地状态
drop TABLE if exists `kylin_field_status`;
CREATE TABLE `kylin_field_status`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `field_status_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'field_status_id',
    `field_id`        varchar(255) NOT NULL DEFAULT '' COMMENT '场地关联id',
    `valid_status`    tinyint      NOT NULL DEFAULT 0 COMMENT '认证状态 0未认证 1已认证 2被拒绝',
    `is_display`      tinyint      NOT NULL DEFAULT 1 COMMENT '是否显示 0不显示 1显示',
    `is_business`     tinyint      NOT NULL DEFAULT 0 COMMENT '是否营业 0不营业 1营业中',
    `change_status`   tinyint      NOT NULL DEFAULT 0 COMMENT '审核状态 0待审核 1已审核 2被拒绝',
    `created_at`      datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_field_status_uid_index` (`field_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '场地状态';
-- 场地关联关系关系
drop TABLE if exists `kylin_field_relations`;
CREATE TABLE `kylin_field_relations`
(
    `mid`                int(11)      NOT NULL AUTO_INCREMENT,
    `field_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'field_relations_id',
    `field_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '场地关联id',
    `created_at`         datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`         datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_field_relations_uid_index` (`field_relations_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '场地关系';


-- 演出
drop TABLE if exists `kylin_performances`;
CREATE TABLE `kylin_performances`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `performances_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performances_id',
    `title`           varchar(255) NOT NULL DEFAULT '' COMMENT '演出名称',
    `type`           tinyint      NOT NULL DEFAULT 3 COMMENT '1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演',
    `img_poster`      varchar(255) NOT NULL DEFAULT '' COMMENT '演出海报',
    `province_id`     varchar(255) NOT NULL DEFAULT '' COMMENT '省id',
    `province_name`   varchar(255) NOT NULL DEFAULT '' COMMENT '省名称',
    `city_id`         int(11)      NOT NULL DEFAULT 0 COMMENT '城市id',
    `city_name`       varchar(255) NOT NULL DEFAULT '' COMMENT '城市名称',
    `district_id`     int(11)      NOT NULL DEFAULT 0 COMMENT '县id',
    `district_name`   varchar(255) NOT NULL DEFAULT '' COMMENT '县名称',
    `approval_url`    varchar(255) NOT NULL DEFAULT '' COMMENT '批文地址',
    `notice`          varchar(255) NOT NULL DEFAULT '' COMMENT '演出公告',
    `sponsor_id`      varchar(255) NOT NULL DEFAULT '' COMMENT '主办方id',
    `sponsor_type`    varchar(255) NOT NULL DEFAULT 'Brand' COMMENT '主办方类型',
    `sponsor`         varchar(255) NOT NULL DEFAULT '' COMMENT '主办方',
    `contacts`        varchar(255) NOT NULL DEFAULT '' COMMENT '联系人',
    `mobile`          varchar(255) NOT NULL DEFAULT '' COMMENT '联系电话',
    `describes`        varchar(255) NOT NULL DEFAULT '' COMMENT '演出简介',
    `details`         longtext              DEFAULT NULL COMMENT '演出详情',
    `notice_image`    text                  DEFAULT NULL COMMENT '购票须知',
    `time_start`      datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '演出开始时间',
    `time_end`        datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '演出结束时间',
    `reject_txt`      varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝理由',
    `sort`            int(11)      NOT NULL DEFAULT 0 COMMENT '权重 高则在上',
    `comment`         varchar(255) NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`      datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performances_uid_index` (`performances_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '演出';
-- 演出状态
drop TABLE if exists `kylin_performance_status`;
CREATE TABLE `kylin_performance_status`
(
    `mid`                   int(11)      NOT NULL AUTO_INCREMENT,
    `performance_status_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_status_id',
    `performance_id`        varchar(255) NOT NULL DEFAULT '' COMMENT '演出关联id',
    `is_show`               tinyint      NOT NULL DEFAULT 1 COMMENT '是否显示 0全部用户可见 1白名单可见 2任何不显示',
    `status`                int          NOT NULL DEFAULT 0 COMMENT '状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退',
    `status_sell`           tinyint      NOT NULL DEFAULT 1 COMMENT '是否售卖 0停止 1正常',
    `is_distribution`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启分销 0关闭 1开启',
    `sync_agent`            tinyint      NOT NULL DEFAULT 0 COMMENT '是否关联小程序 0不关联 1关联',
    `audit_status`          tinyint      NOT NULL DEFAULT -1 COMMENT '-1未提交审核，0提交审核，1审核通过，2审核拒绝',
    `is_true_name`          tinyint      NOT NULL DEFAULT 0 COMMENT '是否实名 0不需要 1需要',
    `limit_count`           int(11)      NOT NULL DEFAULT 0 COMMENT '限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `created_at`            datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`            datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performance_status_uid_index` (`performance_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '演出状态';
-- 演出关联关系
drop TABLE if exists `kylin_performance_relations`;
CREATE TABLE `kylin_performance_relations`
(
    `mid`                      int(11)      NOT NULL AUTO_INCREMENT,
    `performance_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_relations_id',
    `performance_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '演出关联id',
    `copy_id`                  varchar(255) NOT NULL DEFAULT '' COMMENT '复制来源演出id',
    `merchant_id`              varchar(255) NOT NULL DEFAULT '' COMMENT '商户id',
    `field_id`                 varchar(255) NOT NULL DEFAULT '' COMMENT '场地id',
    `road_show_id`             varchar(255) NOT NULL DEFAULT '' COMMENT '巡演id',
    `project_id`               varchar(255) NOT NULL DEFAULT '' COMMENT '专题id',
    `video_id`                 varchar(255) NOT NULL DEFAULT '' COMMENT '视频id',
    `created_at`               datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`               datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `performance_relations_uid_index` (`performance_relations_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '演出状态';
-- 演出分销数据 票逻辑
drop TABLE if exists `kylin_performance_distributions`;
CREATE TABLE `kylin_performance_distributions`
(
    `mid`                          int(11)      NOT NULL AUTO_INCREMENT,
    `performance_distributions_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_distributions_id',
    `ticket_id`                    varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `ticket_scale`                 varchar(5)   NOT NULL DEFAULT '0' COMMENT '演出票提单位%',
    `limit_barter`                 varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `first_agent_scale_money`      varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `first_agent_scale_barter`     varchar(5)   NOT NULL DEFAULT '0' COMMENT '2级积分奖励占比',
    `second_agent_scale_money`     varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `second_agent_scale_barter`    varchar(5)   NOT NULL DEFAULT '0' COMMENT '2级积分奖励占比',
    `comment`                      varchar(255) NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`                   datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`                   datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performance_distributions_uid_index` (`performance_distributions_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '演出状态';


-- 场次
drop TABLE if exists `kylin_ticket_times`;
CREATE TABLE `kylin_ticket_times`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_times_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_times_id',
    `title`           varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
    `type`            tinyint      NOT NULL DEFAULT 1 COMMENT '状态 1单日票 2通票',
    `status`          tinyint      NOT NULL DEFAULT 1 COMMENT '状态 0不可用 1可用',
    `use_start`      datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '售票开始时间',
    `use_end`        datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '售票结束时间',
    `comment`         varchar(255) NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`      datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_times_uid_index` (`ticket_times_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '场次';

-- 场次关联
drop TABLE if exists `kylin_ticket_time_relation`;
CREATE TABLE `kylin_ticket_time_relation`
(
    `mid`                     int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_time_relation_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_time_relation_id',
    `times_id`                varchar(255) NOT NULL DEFAULT '' COMMENT '场次id',
    `performance_id`          varchar(255) NOT NULL DEFAULT '' COMMENT '关联演出id',
    `created_at`              datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`              datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_time_relation_uid_index` (`ticket_time_relation_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '场次关联';

-- 票
drop TABLE if exists `kylin_tickets`;
CREATE TABLE `kylin_tickets`
(
    `mid`                   int(11)       NOT NULL AUTO_INCREMENT,
    `tickets_id`            varchar(255)  NOT NULL DEFAULT '' COMMENT 'tickets_id',
    `title`                 varchar(255)  NOT NULL DEFAULT '' COMMENT '票名称',
    `type`                  tinyint       NOT NULL DEFAULT 1 COMMENT '票类型 1单日票 2通票',
    `price`                 decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '票单价',
    `price_express`         decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '快递费',
    `price_discount_member` decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '会员优惠价格',
    `price_discount`        decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '优惠价格',
    `describes`              varchar(500)  NOT NULL DEFAULT '' COMMENT '票种描述',
    `describe_express`      varchar(500)  NOT NULL DEFAULT '' COMMENT '快递票类型说明',
    `describe_electronic`   varchar(500)  NOT NULL DEFAULT '' COMMENT '电子票票类型说明',
    `advance_minute_member` int(11)       NOT NULL DEFAULT 5 COMMENT '会员提前购买分钟数',
    `time_start`            datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '售卖开始时间',
    `time_end`              datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '售卖结束时间',
    `time_end_express`      datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '快递票结束时间',
    `use_start`             datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '适用开始时间',
    `use_end`               datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '适用结束时间',
    `pay_countdown_minute`  int(11)       NOT NULL DEFAULT 5 COMMENT '支付倒计时时间',
    `sale_remind_minute`    int(11)       NOT NULL DEFAULT 60 COMMENT '开票提醒倒计时（分钟数）',
    `comment`               varchar(255)  NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`            datetime      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`            datetime      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_tickets_uid_index` (`tickets_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '票';
-- 票状态
drop TABLE if exists `kylin_ticket_status`;
CREATE TABLE `kylin_ticket_status`
(
    `mid`               int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_status_id`  varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_status_id',
    `ticket_id`         varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `is_student`        tinyint      NOT NULL DEFAULT 0 COMMENT '是否学生票 0否 1是',
    `is_electronic`     tinyint      NOT NULL DEFAULT 0 COMMENT '是否电子票 0否 1是',
    `is_express`        tinyint      NOT NULL DEFAULT 0 COMMENT '是否快递票 0否 1是',
    `status`            tinyint      NOT NULL DEFAULT 0 COMMENT '票状态 -1删除;0未提交;1审核中;2审核中（自动在售）;3审核通过;4审核未通过;6在售;7停售;8售罄;9未开始;10已结束',
    `counts`            int(11)      NOT NULL DEFAULT 1 COMMENT '可验证次数',
    `status_exchange`   tinyint      NOT NULL DEFAULT 0 COMMENT '兑换状态 6可兑换 7不可兑换',
    `is_show_code`      tinyint      NOT NULL DEFAULT 0 COMMENT '是否显示二维码 0否 1是',
    `qr_code_show_time` datetime     NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '二维码显示时间',
    `is_lack_register`  tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启缺票登记 0否 1是',
    `total_general`     int(11)      NOT NULL DEFAULT 0 COMMENT '总库存',
    `total_exchange`    int(11)      NOT NULL DEFAULT 0 COMMENT '总兑换库存',
    `surplus_general`   int(11)      NOT NULL DEFAULT 0 COMMENT '剩余库存',
    `surplus_exchange`  int(11)      NOT NULL DEFAULT 0 COMMENT '剩余兑换库存',
    `express_type`      tinyint      NOT NULL DEFAULT 1 COMMENT '1寄付 2到付',
    `is_true_name`      tinyint      NOT NULL DEFAULT 0 COMMENT '是否实名 0不需要 1需要',
    `limit_count`       int(11)      NOT NULL DEFAULT 0 COMMENT '限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `is_transfer`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启转赠 0关闭 1开启',
    `is_exclusive`      tinyint      NOT NULL DEFAULT 0 COMMENT '是否会员专属 0不是 1是',
    `is_member`         tinyint      NOT NULL DEFAULT 0 COMMENT '是否关联会员 0不是 1是',
    `created_at`        datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`        datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_status_uid_index` (`ticket_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '票';
-- 票关系
drop TABLE if exists `kylin_ticket_relations`;
CREATE TABLE `kylin_ticket_relations`
(
    `mid`                 int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_relations_id',
    `ticket_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `times_id`            varchar(255) NOT NULL DEFAULT '' COMMENT '关联场次id',
    `created_at`          datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`          datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `ticket_relations_uid_index` (`ticket_relations_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '票';

-- 巡演
drop TABLE if exists `kylin_road_shows`;
CREATE TABLE `kylin_road_shows`
(
    `mid`           int(11)      NOT NULL AUTO_INCREMENT,
    `road_shows_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'road_shows_id',
    `img_poster`    varchar(255) NOT NULL DEFAULT '' COMMENT '巡演封面图',
    `status`        tinyint      NOT NULL DEFAULT 1 COMMENT '状态 0停用 1启用',
    `comment`       varchar(255) NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`    datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_road_shows_uid_index` (`road_shows_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '巡演';


-- 缺票登记 记录
drop TABLE if exists `kylin_lack_registers`;
CREATE TABLE `kylin_lack_registers`
(
    `mid`               int(11)      NOT NULL AUTO_INCREMENT,
    `lack_registers_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'lack_registers_id',
    `ticket_id`         varchar(255) NOT NULL DEFAULT '' COMMENT '票种id',
    `user_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '用户id',
    `user_name`         varchar(255) NOT NULL DEFAULT '' COMMENT '用户昵称',
    `user_mobile`       varchar(255) NOT NULL DEFAULT '' COMMENT '用户手机号',
    `send_status`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否发送短信',
    `ip_address`        varchar(255) NOT NULL DEFAULT '' COMMENT 'IP 地址',
    `created_at`        datetime     NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`        datetime     NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_lack_registers_uid_index` (`lack_registers_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '缺票登记';

-- 专题 <搭售>
drop TABLE if exists `kylin_projects`;
CREATE TABLE `kylin_projects`
(
    `mid`              int(10) unsigned                     NOT NULL AUTO_INCREMENT,
    `projects_id`      varchar(255)                         NOT NULL DEFAULT '' COMMENT 'projects_id',
    `title`            varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '专题名称',
    `time_limit`       int(11)                                       DEFAULT NULL COMMENT '限购时间 单位分钟',
    `status`           tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '0下线 1上线',
    `open_performance` tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐演出',
    `open_goods`       tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐商品',
    `open_tied`        tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐搭售',
    `comment`          varchar(255)                         NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`       datetime                             NULL     DEFAULT NULL,
    `updated_at`       datetime                             NULL     DEFAULT NULL,
    KEY `kylin_projects_uid_index` (`projects_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '专题';
-- 专题关系
drop TABLE if exists `kylin_project_relations`;
CREATE TABLE `kylin_project_relations`
(
    `mid`                  int(10) unsigned                     NOT NULL AUTO_INCREMENT,
    `project_relations_id` varchar(255)                         NOT NULL DEFAULT '' COMMENT 'project_relations_id',
    `project_id`           int(11)                              NOT NULL DEFAULT '0' COMMENT '专题id',
    `type`                 int(11)                              NOT NULL DEFAULT '0' COMMENT '关联类型 1演出 2商品 3限时商品',
    `target_name`          varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '关联名称 关联',
    `target_id`            int(11)                              NOT NULL DEFAULT '0' COMMENT '关联id',
    `item_id`              int(11)                              NOT NULL DEFAULT '0' COMMENT '搭售款式id',
    `item_name`            varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '搭售款式名称',
    `tied_price`           decimal(8, 2)                        NOT NULL DEFAULT '0.00' COMMENT '搭售价格',
    `is_limit`             tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否限购',
    `limit_num`            int(11)                              NOT NULL DEFAULT '0' COMMENT '限购数量 0不限购',
    `created_at`           datetime                             NULL     DEFAULT NULL,
    `updated_at`           datetime                             NULL     DEFAULT NULL,
    PRIMARY KEY (`mid`),
    KEY `kylin_project_relations_uid_index` (`project_relations_id`),
    KEY `kylin_project_relations_project_id_index` (`project_id`),
    KEY `kylin_project_relations_target_id_index` (`target_id`),
    KEY `kylin_project_relations_item_id_index` (`item_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '专题关系';


-- 订单
drop TABLE if exists `kylin_order_tickets`;
CREATE TABLE `kylin_order_tickets`
(
    `mid`                  int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_tickets_id`     varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_tickets_id',
    `user_id`              varchar(255)     NOT NULL DEFAULT '' COMMENT '用户id',
    `user_name`            varchar(255)     NOT NULL DEFAULT '' COMMENT '用户昵称',
    `user_mobile`          varchar(255)     NOT NULL DEFAULT '' COMMENT '用户手机号',
    `performance_title`    varchar(255)     NOT NULL DEFAULT '' COMMENT '演出名称',
    `order_code`           varchar(255)     NOT NULL DEFAULT '' COMMENT '订单号',
    `qr_code`              varchar(255)     NOT NULL DEFAULT '' COMMENT '二维码地址',
    `order_type`           varchar(255)     NOT NULL DEFAULT '' COMMENT '下单方式',
    `order_version`        varchar(255)     NOT NULL DEFAULT '' COMMENT '下单版本',
    `number`               varchar(255)     NOT NULL DEFAULT '' COMMENT '数量',
    `price`                decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '单价',
    `price_member`         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '会员单价',
    `price_total`          decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '应付价格',
    `price_voucher`        decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '优惠价格',
    `price_actual`         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '实付价格',
    `price_express`        decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '快递价格',
    `pay_type`             varchar(255)     NOT NULL DEFAULT '' COMMENT '选择支付方式',
    `payment_type`         varchar(255)     NOT NULL DEFAULT '' COMMENT '实际支付方式',
    `time_pay`             varchar(255)     NOT NULL DEFAULT '' COMMENT '支付时间',
    `express_contacts`     varchar(255)     NOT NULL DEFAULT '' COMMENT '收货人',
    `express_address`      varchar(255)     NOT NULL DEFAULT '' COMMENT '收货地址',
    `express_phone`        varchar(255)     NOT NULL DEFAULT '' COMMENT '收货人联系方式',
    `coupon_type`          varchar(255)     NOT NULL DEFAULT '' COMMENT '券使用类别',
    `get_ticket_type`      varchar(255)     NOT NULL DEFAULT '' COMMENT '取票方式 电子票electronic快递票express',
    `get_ticket_describe`  varchar(255)     NOT NULL DEFAULT '' COMMENT '直播用取票观演码，隔开',
    `pay_countdown_minute` varchar(255)     NOT NULL DEFAULT '' COMMENT '订单过期时间',
    `comment`              varchar(255)     NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`           datetime         NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`           datetime         NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_tickets_uid_index` (`order_tickets_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '订单';
-- 订单关系
drop TABLE if exists `kylin_order_ticket_relations`;
CREATE TABLE `kylin_order_ticket_relations`
(
    `mid`                       int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_relations_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_relations_id',
    `order_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `transfer_id`               varchar(255)     NOT NULL DEFAULT '' COMMENT '转增订单id',
    `live_id`                   varchar(255)     NOT NULL DEFAULT '' COMMENT '关联直播id',
    `is_member`                 varchar(255)     NOT NULL DEFAULT '' COMMENT '购买者是否是会员',
    `created_at`                datetime         NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`                datetime         NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_relations_uid_index` (`order_ticket_relations_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '订单关系';
-- 订单状态
drop TABLE if exists `kylin_order_ticket_status`;
CREATE TABLE `kylin_order_ticket_status`
(
    `mid`                    int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_status_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_status_id',
    `order_id`               varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `express_type`           tinyint          NOT NULL DEFAULT 1 COMMENT '快递方式 1寄付 2到付',
    `transfer_status`        tinyint          NOT NULL DEFAULT 0 COMMENT '转移状态，0未转移，1收到他人转赠，2已转赠给他人',
    `status`                 tinyint          NOT NULL DEFAULT 0 COMMENT '订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭 6部分退款',
    `pay_status`             tinyint          NOT NULL DEFAULT 0 COMMENT '支付状态:0未支付 1已支付 2支付失败',
    `created_at`             datetime         NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`             datetime         NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_status_uid_index` (`order_ticket_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '订单状态';


-- 订单详情
drop TABLE if exists `kylin_order_ticket_entities`;
CREATE TABLE `kylin_order_ticket_entities`
(
    `mid`                      int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_entities_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_entities_id',
    `order_id`                 varchar(255)     NOT NULL DEFAULT '' COMMENT '订单详情关联id',
    `ticket_id`                varchar(255)     NOT NULL DEFAULT '' COMMENT '票务id',
    `user_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '用户id',
    `performance_id`           varchar(255)     NOT NULL DEFAULT '' COMMENT '演出id',
    `enter_type`               int(11)          NOT NULL DEFAULT 1 COMMENT '入场人证件类型 1大陆身份证 2港澳通行证 3台胞证 4护照 5军官证',
    `enter_name`               varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人姓名',
    `enter_mobile`             varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人联系电话',
    `enter_id_code`            varchar(255)     NOT NULL DEFAULT 'z' COMMENT '入场人证件号',
    `status`                   int(11)          NOT NULL DEFAULT 0 COMMENT '出票状态: 0未出票 1已出票',
    `is_payment`               int(11)          NOT NULL DEFAULT 0 COMMENT '支付状态: 0未支付 1已支付 2退款中 3已退款 ',
    `comment`                  varchar(255)     NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`               datetime         NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`               datetime         NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_entities_uid_index` (`order_ticket_entities_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '订单详情';

-- 大麦同步记录 TODO 待定
-- 验票相关 TODO 待定
-- 会员权益修改表 TODO 待定
-- 订单退款 <初步>
drop TABLE if exists `kylin_order_tickets_refund`;
CREATE TABLE `kylin_order_tickets_refund`
(
    `mid`                      int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_tickets_refund_id`  varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_tickets_refund_id',
    `order_id`                 varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `reason`                   varchar(255)     NOT NULL DEFAULT '' COMMENT '退款原因',
    `refund_type`              varchar(10)      NOT NULL DEFAULT '' COMMENT '退款类型 票ticket,快递express',
    `order_ticket_entities_id` varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人id',
    `refund_status`            tinyint          NOT NULL DEFAULT 0 COMMENT '1完成退款,2关闭或者取消退款,3正在退款,4已退款',
    `refund_price`             decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '退款金额',
    `coupon_type`              varchar(10)      NOT NULL DEFAULT '' COMMENT '优惠券类型',
    `coupon_id`                varchar(255)     NOT NULL DEFAULT '' COMMENT '优惠券id',
    `comment`                  varchar(255)     NOT NULL DEFAULT '' COMMENT 'comment',
    `created_at`               datetime         NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`               datetime         NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_tickets_refund_uid_index` (`order_tickets_refund_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT '订单退款';