package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.adam.dto.AdamMemberCodeExcelDto;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberCodeAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberPriceAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberRightsAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.service.adam.dto.admin.*;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.entity.AdamMemberRights;
import com.liquidnet.service.candy.dto.admin.CandyMemberCouponBuildParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponMemberDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Api(tags = "登登登会员")
@Controller
@RequestMapping("adam/member/detail")
public class AdamMemberAdminController extends BaseController {
    private final String prefix = "zhengzai/adam/member/detail";
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberPriceAdminService adamMemberPriceAdminService;
    @Autowired
    IAdamMemberRightsAdminService adamMemberRightsAdminService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;
    @Autowired
    ICandyMgtCouponAdminService candyMgtCouponAdminService;
    @Autowired
    ICandyCouponAdminService candyCouponAdminService;

    @RequiresPermissions("adam:member:detail:view")
    @GetMapping()
    public String detailInfo(ModelMap mmap) {
        AdamMember member = adamMemberService.getOne(Wrappers.lambdaQuery(AdamMember.class)
                .eq(AdamMember::getState, 1)
                .select(
                        AdamMember::getMemberId,
                        AdamMember::getName,
                        AdamMember::getTitle,
                        AdamMember::getSubTitle,
                        AdamMember::getAvatar,
                        AdamMember::getIcon,
                        AdamMember::getLimitation,
                        AdamMember::getLimitbAt,
                        AdamMember::getLimiteAt,
                        AdamMember::getInterestsDetail,
                        AdamMember::getNotes,
                        AdamMember::getType,
                        AdamMember::getIntegralRate
                )
        );
        mmap.put("member", member);

        if (null != member) {
            List<AdamMemberRights> memberRightsList = adamMemberRightsAdminService.list(Wrappers.lambdaQuery(AdamMemberRights.class)
                    .eq(AdamMemberRights::getState, 1)
                    .eq(AdamMemberRights::getMemberId, member.getMemberId())
                    .select(
                            AdamMemberRights::getMrightsId,
                            AdamMemberRights::getCover,
                            AdamMemberRights::getTitle,
                            AdamMemberRights::getSubTitle,
                            AdamMemberRights::getDetail
                    )
            );
            mmap.put("memberRightsList", memberRightsList);

            if (!CollectionUtils.isEmpty(memberRightsList)) {
                List<String> mrightsIdList = memberRightsList.stream().map(AdamMemberRights::getMrightsId).collect(Collectors.toList());

                List<CandyMgtCouponMemberDto> couponMemberDtoList = candyMgtCouponAdminService.listForMgtCouponMemberDto(mrightsIdList);

                mmap.put("couponMemberDtoList", couponMemberDtoList);
            }

            AdamMemberPrice memberPrice = adamMemberPriceAdminService.getOne(Wrappers.lambdaQuery(AdamMemberPrice.class)
                    .eq(AdamMemberPrice::getState, 1)
                    .eq(AdamMemberPrice::getMemberId, member.getMemberId())
                    .select(
                            AdamMemberPrice::getMemberPriceId,
                            AdamMemberPrice::getPrice,
                            AdamMemberPrice::getPriceFixed,
                            AdamMemberPrice::getPriceSpecial,
                            AdamMemberPrice::getDays
                    )
            );
            mmap.put("memberPrice", memberPrice);
        }
        return prefix + "/info";
    }

    @ApiOperation(value = "会员设置:基础信息编辑")
    @RequiresPermissions("adam:member:detail:edit")
    @PostMapping("edit")
    @ResponseBody
    public AjaxResult detailInfoEdit(@Validated AdamMemberBuildParam parameter) {
        return this.toAjax(adamMemberService.edit(parameter));
    }

    @ApiOperation(value = "会员套餐:价格编辑")
    @RequiresPermissions("adam:member:detail:price:edit")
    @PostMapping("price_edit")
    @ResponseBody
    public AjaxResult detailPriceEdit(@Validated AdamMemberPriceBuildParam parameter) {
        return this.toAjax(adamMemberPriceAdminService.edit(parameter));
    }

    @ApiOperation(value = "会员套餐:权益编辑")
    @RequiresPermissions("adam:member:detail:rights:edit")
    @PostMapping("rights_edit")
    @ResponseBody
    public AjaxResult detailRightsEdit(@Validated AdamMemberRightsBuildParam parameter) {
        if (null == parameter.getState() || parameter.getState() != 2) {
            // 这里编辑包含新增、更新、删除分别对应state:1,1,2
            parameter.setState(1);
        }
        return this.toAjax(adamMemberRightsAdminService.edit(parameter));
    }

    @ApiOperation(value = "会员套餐:券编辑")
    @RequiresPermissions("adam:member:detail:coupon:edit")
    @PostMapping("coupon_edit")
    @ResponseBody
    public AjaxResult detailCouponEdit(@RequestBody @Validated CandyMemberCouponBuildParam parameter) {
        Integer busiType = parameter.getBusiType();// 业务类别[0-全场｜1-演出｜2-商品｜3-优先购]
        if (busiType > 0) {
            if (CollectionUtils.isEmpty(parameter.getCouponRuleList())) {
                return AjaxResult.warn("适用范围无效");
            }
        } else {
            parameter.setCouponRuleList(null);
        }
        parameter.setOverlay(busiType < 3 ? 0 : parameter.getOverlay());
        switch (parameter.getCouType()) {// 券类型[1-代金券｜2-满减券]
            case 1:
                BigDecimal valFace = parameter.getValFace();
                if (null == valFace || valFace.compareTo(BigDecimal.ZERO) <= 0) {
                    return AjaxResult.warn("代金券金额无效");
                }
                parameter.setValOver(null);
                parameter.setValMinus(null);
                break;
            case 2:
                BigDecimal valOver = parameter.getValOver();
                BigDecimal valMinus = parameter.getValMinus();
                if (null == valOver || valOver.compareTo(BigDecimal.ZERO) <= 0
                        || null == valMinus || valMinus.compareTo(BigDecimal.ZERO) <= 0) {
                    return AjaxResult.warn("满减金额无效");
                }
                parameter.setValFace(valMinus);
                break;
            default:
                logger.warn("Invalid operation[buildParam.couType={}]", parameter.getCouType());
                return this.error(AjaxResult.Type.WARN, "券类型无效");
        }


        if (StringUtils.isEmpty(parameter.getCouponId())) {
            // 新增券
            return this.toAjax(candyMgtCouponAdminService.saveMgtCouponForMemberRights(parameter));
        } else {
            // 编辑券
            return this.toAjax(candyMgtCouponAdminService.editMgtCouponForMemberRights(parameter));
        }
    }

    @ApiOperation(value = "会员码:列表")
    @RequiresPermissions("adam:member:detail:code:list")
    @PostMapping("code_list")
    @ResponseBody
    public TableDataInfo detailCodeList(AdamMemberCodeListParam parameter) {
        return getDataTable(detailCodeListQuery(parameter));
    }

    private List<AdamMemberCode> detailCodeListQuery(AdamMemberCodeListParam parameter) {
        LambdaQueryWrapper<AdamMemberCode> queryWrapper = Wrappers.lambdaQuery(AdamMemberCode.class).orderByDesc(AdamMemberCode::getCreatedAt);
        queryWrapper.eq(AdamMemberCode::getMemberId, parameter.getMemberId())
                .ne(AdamMemberCode::getState, 2)
                .select(
                        AdamMemberCode::getCode,
                        AdamMemberCode::getState,
                        AdamMemberCode::getMemberId
                );
        return adamMemberCodeAdminService.list(queryWrapper);
    }

    @ApiOperation(value = "会员码:导出")
    @RequiresPermissions("adam:member:detail:code:export")
    @PostMapping("code_export")
    @ResponseBody
    public AjaxResult detailCodeExport(AdamMemberCodeListParam parameter) {
        List<AdamMemberCode> list = detailCodeListQuery(parameter);

        ExcelUtil<AdamMemberCodeExcelDto> excelUtil = new ExcelUtil<>(AdamMemberCodeExcelDto.class);
        List<AdamMemberCodeExcelDto> excelList = new ArrayList<>();
        list.forEach(r -> {
            excelList.add(AdamMemberCodeExcelDto.getNew().copy(r));
        });
        return excelUtil.exportExcel(excelList, "会员码数据");
    }

    @ApiOperation(value = "会员码:生成")
    @RequiresPermissions("adam:member:detail:code:gen")
    @PostMapping("code_gen")
    @ResponseBody
    public AjaxResult detailCodeGen(@Validated AdamMemberCodeGenParam parameter) {
        int count = adamMemberPriceAdminService.count(
                Wrappers.lambdaQuery(AdamMemberPrice.class)
                        .eq(AdamMemberPrice::getMemberPriceId, parameter.getMemberPriceId())
                        .eq(AdamMemberPrice::getMemberId, parameter.getMemberId())
                        .eq(AdamMemberPrice::getState, 1)
        );
        if (count <= 0) {
            logger.warn("会员卡ID/价格ID无效[{}]", parameter);
            return this.error("会员卡ID/价格ID无效");
        }
        return this.toAjax(adamMemberCodeAdminService.createGiftCode(parameter));
    }


//    @Log(title = "会员信息", businessType = BusinessType.LIST)
//    @RequiresPermissions("adam:member:list")
//    @ApiOperation(value = "会员卡列表")
//    @PostMapping("list")
//    public ResponseDto<List<AdamMemberVo>> list() {
//        List<AdamMember> list = adamMemberService.list(
//                Wrappers.lambdaQuery(AdamMember.class).select(
//                        AdamMember::getMemberId, AdamMember::getName, AdamMember::getTitle, AdamMember::getType, AdamMember::getState
//                )
//        );
//        List<AdamMemberVo> vos = new ArrayList<>();
//        list.forEach(r -> {
//            vos.add(AdamMemberVo.getNew().copy(r));
//        });
//        return ResponseDto.success(vos);
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.INSERT)
//    @RequiresPermissions("adam:member:add")
//    @ApiOperation(value = "添加会员卡")
//    @PostMapping("add")
//    public ResponseDto<Object> add(@Valid @RequestBody AdamMemberParam parameter) {
//        adamMemberService.add(parameter);
//        return ResponseDto.success();
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.DETAIL)
//    @RequiresPermissions("adam:member:info")
//    @ApiOperation(value = "会员卡详情")
//    @PostMapping("info")
//    public ResponseDto<Object> info(@NotBlank(message = "会员类型ID不能为空") @RequestParam String memberId) {
//        return ResponseDto.success(adamMemberService.getOne(
//                Wrappers.lambdaQuery(AdamMember.class).eq(AdamMember::getMemberId, memberId)
//        ));
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.UPDATE)
//    @RequiresPermissions("adam:member:edit")
//    @ApiOperation(value = "会员卡编辑")
//    @PostMapping("edit")
//    public ResponseDto<Object> edit(@Valid @RequestBody AdamMemberParam parameter) {
//        adamMemberService.edit(parameter);
//        return ResponseDto.success();
//    }
//
//    @Log(title = "会员信息", businessType = BusinessType.MEMBER_GEN_CODE)
//    @RequiresPermissions("adam:member:gen_code")
//    @ApiOperation(value = "生成兑换码")
//    @PostMapping("gen_code")
//    public ResponseDto<String> genMemberCode(@Valid @RequestBody AdamMemberCodeParam parameter) {
//        if (1 != parameter.getType()) {
//            return ResponseDto.failure("参数有误[TYPE]");
//        }
//        int count = adamMemberPriceAdminService.count(
//                Wrappers.lambdaQuery(AdamMemberPrice.class)
//                        .eq(AdamMemberPrice::getMemberPriceId, parameter.getMemberPriceId())
//                        .eq(AdamMemberPrice::getMemberId, parameter.getMemberId())
//                        .eq(AdamMemberPrice::getState, 1)
//        );
//        if (count <= 0) {
//            return ResponseDto.failure("会员卡ID/价格ID无效");
//        }
//        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
//    }
}
