package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetAppletSubMsgServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 小程序订阅消息记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-22
 */
@Api(tags = "小程序-订阅消息")
@Slf4j
@Validated
@RestController
@RequestMapping("/appletSubMsg")
public class SweetAppletSubMsgController {

    @Autowired
    private SweetAppletSubMsgServiceImpl subMsgService;

    @GetMapping("send")
    @ApiOperation("发送订阅消息,定时任务使用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "活动类型", required = true)
    })
    public ResponseDto send(
            @RequestParam Integer type
    ) {
        return subMsgService.sendMsg(type);
    }

    @GetMapping("sendOfActivityType")
    @ApiOperation("发送订阅消息OfActivityType,特殊情况手动调用使用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "activityType", value = "活动类型", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "targetId", value = "演出ID 作为查询条件", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "timeType", value = "是否判断演出时间 1判断 2不判断"),
    })
    public ResponseDto sendOfActivityType(
            @RequestParam Integer activityType,
            @RequestParam String targetId,
            @RequestParam(defaultValue = "1") Integer timeType
    ) {
        return subMsgService.sendOfActivityType(activityType, targetId, timeType);
    }

    @PostMapping("sendOfMid")
    @ApiOperation("发送订阅消息OfMid,特殊情况手动调用使用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "midList", value = "mid列表逗号分割", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "targetId", value = "演出ID 不作为查询条件", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "timeType", value = "是否判断演出时间 1判断 2不判断"),
    })
    public ResponseDto sendOfMid(
            @RequestParam String midList,
            @RequestParam() String targetId,
            @RequestParam(defaultValue = "1") Integer timeType
    ) {
        return subMsgService.sendOfMid(midList, targetId, timeType);
    }

    // 一次订阅 可以多次发 直到用户取消订阅 所以正规做法应该是记录订阅模版 不关联任何推送数据 等推送的时候查是否订阅某模版
    // 然后发送判断失败是用户取消了 删除订阅记录 或者看取消是否有回调 利用回调处理也可
    // 现在的理解有误 已写完 先用
    // * 实际到了测试发现订阅一次只能发一条 再次发43101
    @PostMapping("create")
    @ApiOperation("添加订阅记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "openId", value = "对应小程序的openId", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "unionId", value = "对应小程序的unionId"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "templateId", value = "模版消息ID,多个用英文逗号分割", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "targetId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "appletType", value = "小程序类型  1草莓 2五百里 3mdsk 4正在 5跳飞船音乐节 6小家伙", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "activityType", value = "活动类型", required = true),
    })
    public ResponseDto<Boolean> create(
            @RequestParam() String openId,
            @RequestParam(defaultValue = "") String unionId,
            @RequestParam() String templateId,
            @RequestParam() String targetId,
            @RequestParam() Integer appletType,
            @RequestParam() Integer activityType
    ) {
        return subMsgService.create(openId, unionId, templateId, targetId, appletType, activityType);
    }

}
