package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamEnum;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyUserService;
import com.liquidnet.service.goblin.constant.NftAccStatusEnum;
import com.liquidnet.service.goblin.dto.GoblinUserNftAccInfoVo;
import com.liquidnet.service.goblin.service.IGoblinNftUserService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

@Slf4j
@Service
public class GoblinNftUserServiceImpl implements IGoblinNftUserService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Resource(name = "galaxyUserServiceImpl")
    private IGalaxyUserService galaxyUserService;

    @Override
    public ResponseDto<GoblinUserNftAccInfoVo> openNftAccount(String uid, String bizCode, String name, String idCard, String mobile) {
        GoblinUserNftAccInfoVo openAccountInfo;
        switch (bizCode) {
            case "NFT_ZX":
                GalaxyUserRegisterReqDto userRegisterReqDto = GalaxyUserRegisterReqDto.getNew();
                userRegisterReqDto.setUserId(uid);
                userRegisterReqDto.setUserName(name);
                userRegisterReqDto.setIdCard(idCard);
                userRegisterReqDto.setMobile(mobile);
                userRegisterReqDto.setIdCardType("1");// 同步com.liquidnet.service.galaxy.constant.GalaxyEnum.CardTypeEnum
                userRegisterReqDto.setRouterType(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode());

//                galaxyUserService.userRegister(userRegisterReqDto);
                queueUtils.sendMsgByRedis(MQConst.GalaxyQueue.JSON_NFT_USER_REGISTER.getKey(), JsonUtils.toJson(userRegisterReqDto));

                openAccountInfo = GoblinUserNftAccInfoVo.getNew();
                openAccountInfo.setCode(NftAccStatusEnum.StatusAcc.ING.getCode());
                openAccountInfo.setMsg(NftAccStatusEnum.StatusAcc.ING.getMsg());
                break;
            default:
                log.warn("#开通业务账号:无效的业务码[UID={},bizCode={},name={},idCard={},mobile={}]", uid, bizCode, name, idCard, mobile);
                return ResponseDto.failure(ErrorMapping.get("140015"));
        }
        openAccountInfo.setTime(LocalDateTime.now());

        goblinRedisUtils.setOpenAccountInfo(uid, openAccountInfo);
        return ResponseDto.success(openAccountInfo);
    }
}
