package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveMapper;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveRelationMapper;
import com.liquidnet.service.kylin.service.admin.IKylinRecommendActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐活动表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Service
public class KylinRecommendActiveServiceImpl extends ServiceImpl<KylinRecommendActiveMapper, KylinRecommendActive> implements IKylinRecommendActiveService {
    @Autowired
    private KylinRecommendActiveMapper kylinRecommendActiveMapper;
    @Autowired
    private KylinRecommendActiveRelationMapper kylinRecommendActiveRelationMapper;

    @Override
    public boolean addKylinRecommendActive(KylinRecommendActive kylinRecommendActive, List<KylinRecommendActiveRelation> kylinRecommendActiveRelations) {
        //生成id
        kylinRecommendActive.setRecommendId(IDGenerator.nextSnowId());
        kylinRecommendActive.setCreatedAt(LocalDateTime.now());
        kylinRecommendActive.setUpdatedAt(LocalDateTime.now());
        kylinRecommendActive.setDelTag(0);
        kylinRecommendActiveMapper.insert(kylinRecommendActive);
        //保存推荐活动关系
        kylinRecommendActiveRelations.forEach(r->{
            r.setCreatedAt(LocalDateTime.now());
            r.setUpdatedAt(LocalDateTime.now());
            r.setDelTag(0);
            r.setRecommendActiveId(kylinRecommendActive.getRecommendId());
            kylinRecommendActiveRelationMapper.insert(r);
        });
        return true;
    }

    @Override
    public boolean updateKylinRecommendActive(KylinRecommendActive kylinRecommendActive) {
        kylinRecommendActiveMapper.updateById(kylinRecommendActive);
        return true;
    }

    @Override
    public List<KylinRecommendActive> pageKylinAcitve(int pageSize, int pageNumber) {
        PageHelper.startPage(pageNumber, pageSize);
        LambdaQueryWrapper<KylinRecommendActive> queryWrapper = Wrappers.lambdaQuery(KylinRecommendActive.class);
        queryWrapper.eq(KylinRecommendActive::getDelTag,0);
        List<KylinRecommendActive> list=kylinRecommendActiveMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public KylinRecommendActive getKylinRecommendActiveById(int mid) {
        //获得推荐活动
        KylinRecommendActive kylinRecommendActive=kylinRecommendActiveMapper.selectById(mid);
        //获得推荐商品
        LambdaQueryWrapper<KylinRecommendActiveRelation> queryWrapper = Wrappers.lambdaQuery(KylinRecommendActiveRelation.class);
        queryWrapper.eq(KylinRecommendActiveRelation::getRecommendActiveId,kylinRecommendActive.getRecommendId());
        queryWrapper.eq(KylinRecommendActiveRelation::getDelTag,0);
        List<KylinRecommendActiveRelation> kylinRecommendActiveRelations = kylinRecommendActiveRelationMapper.selectList(queryWrapper);
        kylinRecommendActive.setList(kylinRecommendActiveRelations);
        return kylinRecommendActive;
    }

    @Override
    public int validateTime(KylinRecommendActive kylinRecommendActive) {
        return   kylinRecommendActiveMapper.validateTime(kylinRecommendActive);
    }
}
