package com.liquidnet.service.platform.controller.goblin.code.task;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "code定时任务")
@Slf4j
@Validated
@RestController
@RequestMapping("codeTask")
public class GoblinNftExCodeTaskController {

    @Autowired
    IGoblinNftExCodeTaskService iGoblinNftExCodeTaskService;

    @PostMapping("generateCode")
    @ApiOperation(value = "定时自动生成兑换码")
    public ResponseDto<String> generateCode(){
        return iGoblinNftExCodeTaskService.generateCode();
    }
}
