package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerKylinTransferResultRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_TRANSFER_RESULT;

@Configuration
public class ConsumerKylinSqlTransferResultRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinTransferResultRdsReceiver consumerKylinTransferResultRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlTransferResult(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.KylinQueue stream = SQL_TRANSFER_RESULT;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerKylinTransferResultRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 验票更新
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveTransferResult(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SQL_TRANSFER_RESULT.getGroup(), getConsumerName(SQL_TRANSFER_RESULT.name() + t)),
//                StreamOffset.create(SQL_TRANSFER_RESULT.getKey(), ReadOffset.lastConsumed()), consumerKylinTransferResultRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 验票更新 */
//
//    @Bean
//    public Subscription subscriptionReceiveTransferResult0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
////    @Bean
////    public Subscription subscriptionReceiveTransferResult1(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveTransferResult(listenerContainer, 1);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionReceiveTransferResult2(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveTransferResult(listenerContainer, 2);
////        listenerContainer.start();
////        return subscription;
////    }
//
////    @Bean
////    public Subscription subscriptionReceiveTransferResult3(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveTransferResult(listenerContainer, 3);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionReceiveTransferResult4(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveTransferResult(listenerContainer, 4);
////        listenerContainer.start();
////        return subscription;
////    }
//
//    /* -------------------------------------------------------- ｜  */
}
