package com.liquidnet.service.order.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.manage.MixOrderParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.param.PayAgainParam;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import com.liquidnet.service.goblin.service.IMixOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

@Slf4j
@Api(tags = "混合售-支付相关")
@RestController
@RequestMapping("/mix")
public class MixOrderController {

    @Autowired
    IMixOrderService mixOrderService;

    @PostMapping("pre")
    @ApiOperation("下单")
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(@RequestBody EncryptedReq<MixOrderParam> param) {
        MixOrderParam payOrderParam = param.getData();
        String uid = CurrentUtil.getCurrentUid();
        return mixOrderService.checkOrder(payOrderParam, uid);
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("fc7bce6d6c2213b866f76493f92224b7")
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(@RequestBody MixOrderParam param) {
        String uid = CurrentUtil.getCurrentUid();
        return mixOrderService.checkOrder(param, uid);
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(@ModelAttribute @Valid SyncOrderParam syncOrderParam) {
        return mixOrderService.syncOrder(syncOrderParam);
    }

//    @ApiOperation(value = "退款回调")
//    @PostMapping(value = "refundSyncOrder")
//    public String refundSyncOrder(RefundCallbackParam refundCallbackParam) {
//        return mixOrderService.refundSyncOrder(refundCallbackParam);
//    }

//    @PostMapping("checkPayment")
//    @ApiOperation("订单状态")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
//    })
//    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @Valid String orderId) {
//        return goblinAppOrderService.checkOrderResult(orderId);
//    }

    @PostMapping("checkPaymentMaster")
    @ApiOperation("订单状态[主订单号]")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResultMasterCode(@RequestParam("masterCode") @Valid String masterCode) {
        return mixOrderService.checkOrderResultMaterCode(masterCode);
    }


}
