package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamUserMemberVo", description = "会员用户信息")
@Data
public class AdamUserMemberVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 9027553500608702757L;
    @ApiModelProperty(position = 11, value = "用户ID")
    private String uid;
    @ApiModelProperty(position = 12, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 13, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 14, value = "用户会员状态[1-NORMAL,2-INVALID]")
    private Integer state;
    @ApiModelProperty(position = 15, value = "过期时间")
    private String expiryAt;
    @ApiModelProperty(position = 16, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 17, value = "更新时间")
    private String updatedAt;

    private static final AdamUserMemberVo obj = new AdamUserMemberVo();

    public static AdamUserMemberVo getNew() {
        try {
            return (AdamUserMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserMemberVo();
        }
    }
}
