package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value = "AdamMemberOrderVo", description = "订单详情展示")
@Data
public class AdamMemberOrderVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1606153856097622877L;
    @ApiModelProperty(position = 0, value = "订单号")
    private String orderNo;
    @ApiModelProperty(position = 1, value = "用户uid")
    private String uid;
    @ApiModelProperty(position = 2, value = "购买方式:0-购买会员,1-购买会员码,2-会员码,3-礼包码")
    private Integer mode;
    @ApiModelProperty(position = 3, value = "会员id")
    private String memberId;
    @ApiModelProperty(position = 4, value = "会员名")
    private String memberName;
    @ApiModelProperty(position = 5, value = "会员价格id")
    private String memberPriceId;
    @ApiModelProperty(position = 6, value = "购买天数")
    private Integer days;
    @ApiModelProperty(position = 7, value = "订单状态:0-未支付,1-已支付,2-已关闭,5-已退款")
    private Integer state;
    @ApiModelProperty(position = 8, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 9, value = "支付终端", allowableValues = "app,wap,js,applet")
    private String deviceFrom;
    @ApiModelProperty(position = 10, value = "支付方式", allowableValues = "alipay,wepay")
    private String payType;
    @ApiModelProperty(position = 11, value = "支付单号")
    private String payNo;
    @ApiModelProperty(position = 12, value = "支付时间")
    private String paymentAt;
    @ApiModelProperty(position = 13, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 14, value = "价格")
    private BigDecimal price;
    @ApiModelProperty(position = 15, value = "客户端IP")
    private String ip;
    @ApiModelProperty(position = 16, value = "客户端来源")
    private String source;
    @ApiModelProperty(position = 17, value = "客户端版本")
    private String version;

    @ApiModelProperty(position = 20, value = "兑换码")
    private String memberCode;

    public static final AdamMemberOrderVo obj = new AdamMemberOrderVo();

    public static AdamMemberOrderVo getNew() {
        try {
            return (AdamMemberOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberOrderVo();
    }

    public static List<Object> getMemberOrderMqList(AdamMemberOrderVo orderVo) {
        List<Object> mqList = new ArrayList<>();
        mqList.add(orderVo.getOrderNo());
        mqList.add(orderVo.getUid());
        mqList.add(orderVo.getMode());
        mqList.add(orderVo.getPrice());
        mqList.add(BigDecimal.valueOf(0));
        mqList.add(orderVo.getMemberName());
        mqList.add(orderVo.getMemberId());
        mqList.add(orderVo.getMemberPriceId());
        mqList.add(orderVo.getDays());
        mqList.add(orderVo.getState());
        mqList.add(orderVo.getMemberNo());
        mqList.add(orderVo.getDeviceFrom());
        mqList.add(orderVo.getPayType());
        mqList.add(orderVo.getPayNo());
        mqList.add(orderVo.getPaymentAt());
        mqList.add(orderVo.getCreatedAt());
        mqList.add(orderVo.getCreatedAt());
        mqList.add(orderVo.getIp());
        mqList.add(orderVo.getSource());
        mqList.add(orderVo.getVersion());
        return mqList;
    }
}
