package com.liquidnet.service.kylin.dao;

import com.liquidnet.service.kylin.entity.KylinPerformances;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class OrderRefundBatchDao implements Serializable {

    private String refundBatchId;

    private String targetId;

    private Integer status;
    private String statusName;

    private LocalDateTime executorAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private KylinPerformances performancesInfo;

    public void setStatusName(Integer status){
        this.status=status;
        switch (status){
            case 1:
                this.statusName="申请退款";
                break;
            case 2:
                this.statusName="取消退款";
                break;
            case 3:
                this.statusName="运营驳回审核";
                break;
            case 4:
                this.statusName="运营通过审核";
                break;
            case 5:
                this.statusName="财务驳回审核";
                break;
            case 6:
                this.statusName="财务通过审核";
                break;
            default:
                this.statusName="其他";
                break;
        }
    }

}
