package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐活动表
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRecommendActive implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 推荐活动id
     */
    private String recommendId;

    /**
     * 开启时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 1NFT2组合购3演出4商品
     */
    private Integer activeType;

    /**
     * 活动绑定id
     */
    private String activeBindId;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    /**
     * 0开启，1未开启
     */
    private Integer status;

    @TableField(exist = false)
    private List<KylinRecommendActiveRelation> list;


}
