package com.liquidnet.service.platform.controller.goblin.sku;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.param.GoblinNftExSkuParam;
import com.liquidnet.service.goblin.service.IGoblinNftExSkuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: wll
 * @Date:Create：in 2022/4/19 2:56 下午
 */

@Api(tags = "nft兑换活动和sku关联")
@Slf4j
@Validated
@RestController
@RequestMapping("sk")
public class GoblinNftExSkuController {

    @Autowired
    IGoblinNftExSkuService iGoblinNftExSkuService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加nft兑换和sku的关联")
    @PostMapping("add")
    public ResponseDto<Object> add(@Valid @RequestBody List<GoblinNftExSkuParam> goblinNftExSkuParams){
        return ResponseDto.success(iGoblinNftExSkuService.add(goblinNftExSkuParams));
    }



}
