package com.liquidnet.service.sweet.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.sweet.entity.SweetLostFoundItem;
import com.liquidnet.service.sweet.param.SweetLostFoundItemParam;
import com.liquidnet.service.sweet.vo.SweetLostFoundItemVo;

import java.util.List;

/**
 * 失物招领信息服务接口
 *
 * @author liquidnet
 * @since 2025-01-18
 */
public interface ISweetLostFoundItemService extends IService<SweetLostFoundItem> {

    /**
     * 发布失物信息
     *
     * @param item 失物信息
     * @return 是否成功
     */
    boolean publishItem(SweetLostFoundItemParam item);

    /**
     * 编辑失物信息
     *
     * @param item 失物信息
     * @return 是否成功
     */
    boolean editItem(SweetLostFoundItemParam item);

    /**
     * 删除失物信息
     *
     * @param id 物品ID
     * @return 是否成功
     */
    boolean deleteItem(Long id);

    /**
     * 获取失物信息详情
     *
     * @param id 物品ID
     * @return 失物信息详情
     */
    SweetLostFoundItemVo getItemDetail(Long id);

    /**
     * 根据演出ID查询失物信息列表
     *
     * @param itemType      演出ID
     * @param performanceId 演出ID
     * @return 失物信息列表
     */
    List<SweetLostFoundItemVo> getItemList(Integer itemType, String performanceId);

}