package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

public class SensitizeUtil {

    /**
     * [中文姓名] 只显示第一个汉字，其他隐藏为星号
     *
     * @param userName 姓名
     * @return 张**
     */
    public static String chineseName(String userName) {
        if (StringUtils.isBlank(userName)) {
            return "";
        }
        return StringUtils.rightPad(
                StringUtils.left(userName, StringUtils.length(userName) > 3 ? 2 : 1),
                StringUtils.length(userName), "*"
        );
    }

    /**
     * [自定义]隐藏处理，前面保留`index`位明文，后面保留`end`位明文
     *
     * @param str   待处理字符串
     * @param index 前面保留N位
     * @param end   后面保留N位
     * @return ???****???
     */
    public static String custom(String str, int index, int end) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return StringUtils.left(str, index).concat(
                StringUtils.removeStart(
                        StringUtils.leftPad(StringUtils.right(str, end), StringUtils.length(str), "*"), "***"
                )
        );
    }

    /**
     * [电子邮箱] 邮箱前缀隐藏，用星号代替，@及后面的地址显示
     *
     * @param email 邮箱地址
     * @return ?*****@163.com
     */
    public static String email(String email) {
        if (StringUtils.isBlank(email)) {
            return "";
        }
        int index = StringUtils.indexOf(email, "@");
        if (index <= 1) {
            return email;
        } else {
            return StringUtils.rightPad(
                    StringUtils.left(email, 1), 6, "*"
            ).concat(
                    StringUtils.mid(email, index, StringUtils.length(email))
            );
        }
    }
}
