package com.liquidnet.service.dragon.channel.wepay.resp;

import com.liquidnet.service.dragon.utils.XmlUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: WepayPayRespDto
 * @Package com.liquidnet.service.dragon.channel.wepay.resp
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/12 10:40
 */
@Data
@XStreamAlias("xml")
public class WepayPayRespDto {
    @XStreamAlias("return_code")
    private String returnCode; //SUCCESS
    @XStreamAlias("return_msg")
    private String returnMsg; //OK
    @XStreamAlias("result_code")
    private String resultCode; //SUCCESS
    @XStreamAlias("mch_id")
    private String mchId; //1551961491
    @XStreamAlias("appid")
    private String appid; //wx3498304dda39c5a1
    @XStreamAlias("nonce_str")
    private String nonceStr; //Y6Czfx4lhuSv0yUD
    @XStreamAlias("sign")
    private String sign; //97001E77813055D03E3009F67A836D62
    @XStreamAlias("prepay_id")
    private String prepayId; //wx111130490949693ab00f679072ea730000
    @XStreamAlias("trade_type")
    private String tradeType; //MWEB
    @XStreamAlias("mweb_url")
    private String mwebUrl; //https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx111130490949693ab00f679072ea730000&package=2011082926
    @XStreamAlias("openid")
    private String openid;
    @XStreamAlias("is_subscribe")
    private String is_subscribe;
    @XStreamAlias("bank_type")
    private String bank_type;
    @XStreamAlias("fee_type")
    private String fee_type;
    @XStreamAlias("total_fee")
    private String total_fee;
    @XStreamAlias("cash_fee_type")
    private String cash_fee_type;
    @XStreamAlias("cash_fee")
    private String cash_fee;
    @XStreamAlias("transaction_id")
    private String transaction_id;
    @XStreamAlias("out_trade_no")
    private String out_trade_no;
    @XStreamAlias("attach")
    private String attach;
    @XStreamAlias("time_end")
    private String time_end;
    @XStreamAlias("err_code")
    private String err_code;
    @XStreamAlias("err_code_des")
    private String err_code_des;


    public static void xmlToBean(){
        String xmlStr = "<xml><return_code><![CDATA[SUCCESS]]></return_code>\n" +
                "<return_msg><![CDATA[OK]]></return_msg>\n" +
                "<result_code><![CDATA[SUCCESS]]></result_code>\n" +
                "<mch_id><![CDATA[1551961491]]></mch_id>\n" +
                "<appid><![CDATA[wx86f9777acf2cb585]]></appid>\n" +
                "<nonce_str><![CDATA[sBhYlCmhZYveVghZ]]></nonce_str>\n" +
                "<sign><![CDATA[C3760928A28B51A74A41F856D0B0B034]]></sign>\n" +
                "<openid><![CDATA[oWadFuJlPcQS_iD1YQGfJ-cfVKQI]]></openid>\n" +
                "<is_subscribe><![CDATA[N]]></is_subscribe>\n" +
                "<trade_type><![CDATA[MICROPAY]]></trade_type>\n" +
                "<bank_type><![CDATA[OTHERS]]></bank_type>\n" +
                "<fee_type><![CDATA[CNY]]></fee_type>\n" +
                "<total_fee>1</total_fee>\n" +
                "<cash_fee_type><![CDATA[CNY]]></cash_fee_type>\n" +
                "<cash_fee>1</cash_fee>\n" +
                "<transaction_id><![CDATA[4200001413202202214878147508]]></transaction_id>\n" +
                "<out_trade_no><![CDATA[PAY202202211642184423445159]]></out_trade_no>\n" +
                "<attach><![CDATA[]]></attach>\n" +
                "<time_end><![CDATA[20220221164220]]></time_end>\n" +
                "</xml>  ";
        WepayPayRespDto respDto= XmlUtil.toBean(xmlStr, WepayPayRespDto.class);
     System.out.println("respDto.getAppid()=="+respDto.getAppid());
     System.out.println("respDto.getMwebUrl()==="+respDto.getMwebUrl());
    }

    public static void main(String[] args) {
        xmlToBean();
    }
}
