package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "福袋兑换码详情VO")
public class KylinLuckyBagCodeDetailVo {

    @ApiModelProperty(value = "兑换码")
    private String code;

    @ApiModelProperty(value = "用户ID")
    private String uid;

    @ApiModelProperty(value = "福袋ID")
    private String luckyBagId;

    @ApiModelProperty(value = "关联订单ID")
    private String orderId;

    @ApiModelProperty(value = "状态 0：不可用 1：可用 2：已领取")
    private int state;

    @ApiModelProperty(value = "发放时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "领取时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updatedAt;
}
