package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 用户信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamUserInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String uid;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 性别
     */
    private String sex;

    /**
     * 生日YYYY-MM-DD
     */
    private LocalDate birthday;

    /**
     * 常住地/区域
     */
    private String area;

    /**
     * 个性签名
     */
    private String signature;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 背景图
     */
    private String background;

    /**
     * 身份二维码
     */
    private String qrCode;

    /**
     * 身份二维码
     */
    private String qrPic;

    /**
     * 音乐标签
     */
    private String tagMe;

    /**
     * 旧数据迁移
     * 融云token
     */
    private String rongCloudToken;

    /**
     * 旧数据迁移（stringid为上上版系统用户id，uid为上版系统用户id，旧数据迁移至当前版本延用原uid）
     * 0-老融云token(用stringid生成),1重新生成过的token(用uid生成)
     */
    private Integer rongCloudTag;

    private String comment;


}
