package com.liquidnet.service.feign.sweet.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

@Component
@FeignClient(name = "liquidnet-service-sweet",
        contextId = "FeignSweetTaskActivityClient", path = "",
        url = "${liquidnet.service.sweet.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignSweetTaskActivityClient {

    @GetMapping("sweet/sweetCityVote/setStatList")
    ResponseDto<Boolean> setStatList();

}
