package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrgAndUserVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrganizationParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrganizationVo;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileOrganizationService;
import com.liquidnet.service.smile.entity.SmileOrganization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "组织管理")
@RestController
@RequestMapping("/smile/organization")
public class SmileOrganizationController {

    @Autowired
    ISmileOrganizationService smileOrganizationService;

    @PostMapping("/list")
    @ApiOperation("获取组织列表")
    @ResponseBody
    public AjaxResult organizationList(SmileOrganizationParam smileOrganizationParam){
        PageInfo<SmileOrganizationVo> organizationList = smileOrganizationService.organizationList(smileOrganizationParam);
        return AjaxResult.success(organizationList);
    }

    @PostMapping("/create")
    @ApiOperation("新增组织")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileOrganizationVo smileOrganizationVo){
        if (smileOrganizationService.create(smileOrganizationVo)){
            return AjaxResult.success();
        }
        return AjaxResult.warn("组织已添加");
    }

    @PostMapping("/updateOrg")
    @ApiOperation("修改组织")
    @ResponseBody
    public AjaxResult updateOrg(@RequestBody SmileOrganization smileOrganization){
        if (smileOrganizationService.update(smileOrganization)){
            return AjaxResult.success();
        }else {
            return AjaxResult.error();
        }
    }

    @PostMapping("/getOrgById")
    @ApiOperation("根据组织id获取信息")
    @ResponseBody
    public AjaxResult getOrgById(@RequestParam(name = "id", required = true)Long id){
        SmileOrgAndUserVo orgById = smileOrganizationService.getOrgById(id);
        return AjaxResult.success(orgById);
    }

}
