package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserCheckVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserCheckParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserCheckService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.smile.entity.SmileOrganization;
import com.liquidnet.service.smile.entity.SmileUserCheck;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import com.liquidnet.service.smile.mapper.SmileOrganizationMapper;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.liquidnet.service.smile.mapper.SmileUserCheckMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-15
 */
@Service
public class SmileUserCheckServiceImpl extends ServiceImpl<SmileUserCheckMapper, SmileUserCheck> implements ISmileUserCheckService {

    @Autowired
    SmileUserCheckMapper smileUserCheckMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Autowired
    SmileOrganizationMapper smileOrganizationMapper;

    @Override
    public PageInfo<SmileUserCheckDao> listUserCheck(UserCheckParam userCheckParam) {
        PageInfo<SmileUserCheckDao> pageInfo;
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(userCheckParam);
            List<SmileUserCheckDao> smileUserCheckDaos = smileUserMapper.selectUserCheck(map);
            pageInfo = new PageInfo<>(smileUserCheckDaos);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public boolean create(SmileUserCheck smileUserCheck) {
        if (smileUserCheck.getUid() != null) {
            //uid=uid   state！=1
            LambdaQueryWrapper<SmileUserCheck> queryWrapper = Wrappers.lambdaQuery(SmileUserCheck.class);
            queryWrapper.eq(SmileUserCheck::getUid, smileUserCheck.getUid());
            queryWrapper.eq(SmileUserCheck::getState, 1);
            if (smileUserCheckMapper.selectOne(queryWrapper) == null) {
                smileUserCheck.setCreatedDate(LocalDateTime.now());
                smileUserCheck.setUpdatedDate(LocalDateTime.now());
                smileUserCheck.setState(1);
                smileUserCheck.setDelTag(0);
                return smileUserCheckMapper.insert(smileUserCheck) > 0;
            }
        }
        return false;
    }

    @Override
    public AjaxResult updateUserCheckById(SmileUserCheckVo smileUserCheckVo) {
        //判断是否通过
        if (smileUserCheckVo.getState().equals(3)) {
            //申请被驳回
            SmileUserCheck smileUserCheck = new SmileUserCheck();
            BeanUtils.copyProperties(smileUserCheckVo, smileUserCheck);
            smileUserCheck.setUpdatedDate(LocalDateTime.now());
            smileUserCheckMapper.updateById(smileUserCheck);
        } else {
            //通过审核
            //判断是否是总代
            if (smileUserCheckVo.getType().equals(1)) {
                //查询组织是否有总代   没有则设置  有则返回异常
                LambdaQueryWrapper<SmileOrganization> orgQueryWrapper = Wrappers.lambdaQuery(SmileOrganization.class);
                orgQueryWrapper.eq(SmileOrganization::getId, smileUserCheckVo.getOrgId());
                orgQueryWrapper.eq(SmileOrganization::getDelTag, 0);
                SmileOrganization smileOrganization = smileOrganizationMapper.selectOne(orgQueryWrapper);
                if (smileOrganization != null && smileOrganization.getAgentId() == null) {
                    //没有总代  修改代理
                    smileOrganization.setUpdatedDate(LocalDateTime.now());
                    smileOrganization.setAgentId(smileUserCheckVo.getUid());
                    smileOrganizationMapper.updateById(smileOrganization);
                } else {
                    //有总代
                    return AjaxResult.warn("该分组已经存在总代身份");
                }
            }
            //修改审核信息
            smileUserCheckMapper.updateCheck(smileUserCheckVo.getId());
            //修改user代理 id
            smileUserMapper.updateUserByUid(smileUserCheckVo.getUid(), smileUserCheckVo.getOrgId(), smileUserCheckVo.getType());
        }
        return AjaxResult.success();
    }


}
