package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileUserVoOrg;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@SuppressWarnings("all")
public class SmileUserServiceImpl extends ServiceImpl<SmileUserMapper, SmileUser> implements ISmileUserService {

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Override
    public PageInfo<SmileUserVo> userList(SmileUserParam smileUserParam) {
        PageInfo<SmileUserVo> pageInfo;
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(smileUserParam);
            List<SmileUserVo> smileUserVos = smileUserMapper.selectUserList(map).stream().map(smileUser -> {
                SmileUserVo smileUserVo = new SmileUserVo();
                BeanUtils.copyProperties(smileUser, smileUserVo);
                return smileUserVo;
            }).collect(Collectors.toList());
            pageInfo = new PageInfo<SmileUserVo>(smileUserVos);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public SmileUser getUserById(Long id) {
        log.info("查询用户id:{}", id);
        //查询未删除，未通过审核的用户,id=uid
        LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
        queryWrapper.eq(SmileUser::getDelTag, 0);
        queryWrapper.eq(false, SmileUser::getType, 0);
        queryWrapper.eq(SmileUser::getId,id);
        SmileUser smileUser = smileUserMapper.selectOne(queryWrapper);
        log.info("smileUser:{}", smileUser);
        return smileUser;
    }

    @Override
    public Boolean create(SmileUser smileUser) {
        smileUser.setCreatedDate(LocalDateTime.now());
        smileUser.setUpdatedDate(LocalDateTime.now());
        smileUser.setDelTag(0);
        smileUser.setState(0);
        log.debug("smileUser:{}", smileUser);
        LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
        queryWrapper.eq(SmileUser::getUid,smileUser.getUid());
        queryWrapper.eq(SmileUser::getDelTag,0);
        //查询是否有重复uid用户
        if (smileUserMapper.selectOne(queryWrapper)==null){
            int id = smileUserMapper.insert(smileUser);
            log.debug("return id:{}.", smileUser.getUid());
            SmileUserVO smileUserVO = new SmileUserVO();
            BeanUtils.copyProperties(smileUser, smileUserVO);
            //存入redis中
            smileRedisUtils.set(SmileRedisConst.SMILE_USER + smileUser.getUid(),smileUserVO);
            return true;
        }
        return false;
    }

    @Override
    public List<SmileUserVoOrg> getUserListByOrgId(Long orgId, Long agentId) {
        //查询根据组织ID查询人员信息
        LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
        queryWrapper.eq(SmileUser::getOrgId, orgId);
        List<SmileUserVoOrg> smileUserVos = smileUserMapper.selectList(queryWrapper).stream().map(smileUser -> {
            SmileUserVoOrg smileUserVo = new SmileUserVoOrg();
            BeanUtils.copyProperties(smileUser, smileUserVo);
            return smileUserVo;
        }).collect(Collectors.toList());
        return smileUserVos;
    }

}