package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminActiveTypeService;
import com.liquidnet.service.kylin.dto.param.CreateActiveTypeParam;
import com.liquidnet.service.sweet.entity.SweetActiveType;
import com.liquidnet.service.sweet.mapper.SweetActiveTypeMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@Slf4j
public class SweetAdminActiveTypeServiceImpl implements ISweetAdminActiveTypeService {

    @Autowired
    SweetActiveTypeMapper sweetActiveTypeMapper;

    @Override
    public List<SweetActiveType> getList(int page, int size) {
        return sweetActiveTypeMapper.selectList(Wrappers.lambdaQuery(SweetActiveType.class));
    }

    @Override
    public Boolean changeInfo(CreateActiveTypeParam createActiveTypeParam) {
        SweetActiveType bean = SweetActiveType.getNew();
        bean.setActiveName(createActiveTypeParam.getActiveName());
        bean.setAlarmNum(createActiveTypeParam.getAlarmNum());
        bean.setMaxCount(createActiveTypeParam.getMaxCount());
        bean.setType(createActiveTypeParam.getType());
        return sweetActiveTypeMapper.update(bean, Wrappers.lambdaUpdate(SweetActiveType.class).eq(SweetActiveType::getMid, createActiveTypeParam.getMid())) > 0;
    }

    @Override
    public Boolean addInfo(CreateActiveTypeParam createActiveTypeParam) {
        SweetActiveType bean = SweetActiveType.getNew();
        bean.setActiveName(createActiveTypeParam.getActiveName());
        bean.setAlarmNum(createActiveTypeParam.getAlarmNum());
        bean.setMaxCount(createActiveTypeParam.getMaxCount());
        bean.setType(createActiveTypeParam.getType());
        return sweetActiveTypeMapper.insert(bean) == 1;
    }

    @Override
    public SweetActiveType details(String mid) {
        return sweetActiveTypeMapper.selectOne(Wrappers.lambdaQuery(SweetActiveType.class).eq(SweetActiveType::getMid, mid));
    }
}
