package com.liquidnet.service.kylin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeStatisticalDao;
import com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeTicketStatisticalDao;
import com.liquidnet.service.kylin.dao.report.KylinPerformancesDto;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 演出 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface KylinPerformancesMapper extends BaseMapper<KylinPerformances> {

    //列表
    List<PerformancePartnerListDao> partnerPerformanceList(Map<String,Object> map);

    //列表
    List<PerformanceAdminListDao> misPerformanceList(Map<String,Object> map);

    //根据巡演查询 通过审核演出列表
    List<PerformanceTitleDao> misTitleByRoadShowIdList(String roadShowId);

    //根据巡演查询 通过审核演出列表
    List<PerformanceTitleDao> misTitleByStatusList(@Param("status") String status, @Param("title") String title);

    //根据演出id 搜索到下面全部场次票
    List<PerformanceSimpleAllDao> misPerformanceDetail(@Param("performanceList") List<String> performanceList);

    //推荐列表
    List<PerformanceRecommendAdminDao> reCommendPerformanceList();

    //演出 会员演出相关信息
    PerformanceTitleDao misPerformanceMemberInfo(String performancesId);

    //演出 会员票相关信息
    List<TicketMemberAuditDao> misTicketMemberInfo(String performancesId);

    //演出 会员票相关信息
    PerformanceRecommendDao getRecommend(String performancesId);

    List<PerformanceOrderStatisticalDao> getPerformanceOrderStatisticalList(String performancesId);

    List<PerformanceSponsorDao> getPerformanceSponsorList(String sponsorType);

    List<PerformanceExpressPerformanceListAdminDao> performanceExpressPerformanceList(Map<String, Object> map);

    PerformanceExpressPerformanceListAdminDao countExpressNumber(String performancesId);

    List<OrderExportDao> exportOrderByPerformanceIdAll(String performancesId);
    List<OrderExportDao> exportOrderByPerformanceIdPay(String performancesId);

    PerformanceSimpleAllDao getPerformanceSimpleByPerformancesId(String performancesId);
    PerformanceSimpleAllDao getPerformanceSimpleByTimesId(String timesId);
    PerformanceSimpleAllDao getPerformanceSimpleByTicketId(String ticketId);

    void updateComment(@Param("sort") String sort);

    void updateCommentByPer(@Param("sort") String sort,@Param("performancesId") String performancesId);

    List<KylinPerformances> selectByComment();

    List<KylinPerformancesDto> selectPerIdByAgent(@Param("title") String title, @Param("timeEndS") String timeEndS, @Param("timeEndE") String timeEndE);

    List<KylinPerformancesDao> selectTicketIdByPerId(@Param("performancesId") String performancesId);

    //订单时间查订单信息
    List<OrderExportDao> exportOrderByOrderTime(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //演出时间查订单信息
    List<OrderExportDao> exportOrderByShowTime(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //演出id查订单信息
    List<OrderExportDao> exportOrderByShowId(@Param("showId") String showId);
    //会员订单信息
    List<MemberOrderExportDao> exportMemberOrder(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //商品订单信息
    List<CommodityOrderExportDao> exportCommodityOrder(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);

    List<KylinPerformancesDto> getListAll(String title);

    /**
     * 演出预约统计
     * @author zjp
     * @param performancesId 
     * @return: com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeStatisticalDao
     * @date 2024/3/18 14:19
    */
    KylinPerformanceSubscribeStatisticalDao getSubscribeStatisticalByPerformancesId(@Param("performancesId")String performancesId);

    /**
     * 获取演出票种预约人数
     * @author zjp
     * @param performancesId 
     * @return: java.util.List<com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeTicketStatisticalDao>
     * @date 2024/3/18 16:06
    */
    List<KylinPerformanceSubscribeTicketStatisticalDao> getSubscribeTicketStatisticalByPerformancesId(@Param("performancesId")String performancesId);

    /**
     * 获取开票提醒需要push用户信息
     * @author zjp
     * @param type  推送类型 0 开票提醒
     * @param pushRange 推送设备唯一标识
     * @param isPush  推送设备 ios android
     * @return: java.util.List<com.liquidnet.service.kylin.dao.KylinPerformancesSubscribeDao>
     * @date 2024/3/21 16:29
    */
    List<KylinPerformancesSubscribeDao> performanceSubscribePush(@Param("type")Integer type,@Param("pushRange")String pushRange,@Param("isPush")Integer isPush);

    /**
     * 批量修改开票提醒推送状态
     * @author zjp
     * @param ids 
     * @return: void
     * @date 2024/3/21 18:02
    */
    void  updatePerformanceSubscribePushById(@Param("ids")List<Integer> ids);
}
