package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontSelectGoodsService;
import com.liquidnet.common.cache.redis.util.RedisGoblinUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontSelectGoods;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinFrontSelectGoodsMapper;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontSelectGoodsParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 精选商品
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-04
 */
@Service
public class GoblinFrontSelectGoodsServiceImpl extends ServiceImpl<GoblinFrontSelectGoodsMapper, GoblinFrontSelectGoods> implements IGoblinFrontSelectGoodsService {

    //private GoblinGoodsMapper goblinGoodsMapper;
    @Autowired
    private GoblinFrontSelectGoodsMapper goblinFrontSelectGoodsMapper;
    @Autowired
    private RedisGoblinUtil redisGoblinUtil;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;

    public boolean create(GoblinFrontSelectGoods goblinFrontSelectGoods){
        List list= this.getList();
        if(list.size()>0){
            return false;
        }
        //
        goblinFrontSelectGoods.setCreateTime(LocalDateTime.now());
        goblinFrontSelectGoods.setUpdateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontSelectGoods.setSelectGoodsId(IDGenerator.nextSnowId());
        //增加 banner
        //goblinFrontSeckillMapper.insert(goblinFrontSeckill);
        goblinFrontSelectGoodsMapper.insert(goblinFrontSelectGoods);
        return true;
    }
    public GoblinFrontSelectGoods getOne(Long id){
        return  goblinFrontSelectGoodsMapper.selectById(id);
    }

    public boolean delte(Long id){
        GoblinFrontSelectGoods goblinFrontSelectGoods=goblinFrontSelectGoodsMapper.selectById(id);
        goblinFrontSelectGoods.setDelTag(1);
        this.update(goblinFrontSelectGoods);
        return true;
    }

    public boolean update(GoblinFrontSelectGoods goblinFrontSelectGoods){
        if(goblinFrontSelectGoods.getMid()>0){
            goblinFrontSelectGoods.setUpdateTime(LocalDateTime.now());
            goblinFrontSelectGoodsMapper.updateById(goblinFrontSelectGoods);
        }else{
            this.create(goblinFrontSelectGoods);
        }
        return true;
    }

   public  List getList(){
       LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
       queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
      List<GoblinFrontSelectGoods> list= goblinFrontSelectGoodsMapper.selectList(queryWrapper);
       List<GoblinGoods> goblinGoodsList =new ArrayList<>();
       List<GoblinFrontSelectGoodsParam> goodsP =new ArrayList<>();
       for(GoblinFrontSelectGoods goblinFrontSelectGoods:list){
           String spuids=goblinFrontSelectGoods.getSpuId();
           if(StringUtil.isNotBlank(spuids)){
               String[] spuIds=spuids.split(",");
               for(String id:spuIds){
                   LambdaQueryWrapper<GoblinGoods> queryWrappers = Wrappers.lambdaQuery(GoblinGoods.class);
                   queryWrappers.ne(GoblinGoods::getDelFlg,"1");
                   queryWrappers.eq(GoblinGoods::getSpuId,id);
                   List<GoblinGoods> goodsList= goblinGoodsMapper.selectList(queryWrappers);
                   if(goodsList.size()>0){
                       goblinGoodsList.add(goodsList.get(0));
                   }
               }
           }
           GoblinFrontSelectGoodsParam goblinFrontSelectGoodsParam=new GoblinFrontSelectGoodsParam();
           BeanUtils.copyProperties(goblinFrontSelectGoods,goblinFrontSelectGoodsParam);
           goblinFrontSelectGoodsParam.setGoblinGoodsList(goblinGoodsList);
           goodsP.add(goblinFrontSelectGoodsParam);
       }


       return goodsP;


   }
    public boolean online(){
      //查询
        LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
        queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
        List<GoblinFrontSelectGoods> list=goblinFrontSelectGoodsMapper.selectList(queryWrapper);
        if(list.size()>0){
            //放入mongodb
            GoblinFrontSelectGoods goblinFrontSelectGoods= list.get(0);
            GoblinFrontSelectGoods  goblinFrontSelectGoods1= mongoTemplate.findOne(Query.query(Criteria.where("selectGoodsId").is(goblinFrontSelectGoods.getSelectGoodsId())), GoblinFrontSelectGoods.class, GoblinFrontSelectGoods.class.getSimpleName());
            if(null==goblinFrontSelectGoods1){
                mongoTemplate.save(goblinFrontSelectGoods,GoblinFrontSelectGoods.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontSelectGoods)));
                mongoTemplate.getCollection(GoblinFrontSelectGoods.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("selectGoodsId").is(goblinFrontSelectGoods.getSelectGoodsId())).getQueryObject(),
                        orderObject
                );
            }
            redisGoblinUtil.set(GoblinRedisConst.SELECT_GOODS,list);
        }

        return  true;
    }
}
