package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinDigitalArtworkCertVo", description = "藏品证书信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinDigitalArtworkCertVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5348463844779743371L;
    @ApiModelProperty(position = 11, value = "藏品名称")
    private String name;
    @ApiModelProperty(position = 12, value = "创作者")
    private String author;
    @ApiModelProperty(position = 13, value = "发行方")
    private String publisher;
    @ApiModelProperty(position = 14, value = "收藏者")
    private String collector;
    @ApiModelProperty(position = 15, value = "藏品简介")
    private String intro;

    // 流转记录


    private static final GoblinDigitalArtworkCertVo obj = new GoblinDigitalArtworkCertVo();

    public static GoblinDigitalArtworkCertVo getNew() {
        try {
            return (GoblinDigitalArtworkCertVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinDigitalArtworkCertVo();
        }
    }
}
