package com.liquidnet.service.stone.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分物品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StoneScoreItems implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 目标id
     */
    private String targetId;

    /**
     * 目标名称
     */
    private String targetTitle;

    /**
     * 目标类型[1-券|1x-商品维度|2x-演出维度]
     */
    private Integer type;

    /**
     * 展示图
     */
    private String img;

    /**
     * 所需积分
     */
    private BigDecimal score;

    /**
     * 所需金额
     */
    private BigDecimal price;

    /**
     * 总库存[-999-不限]
     */
    private Integer generalTotal;

    /**
     * 剩余库存
     */
    private Integer generalSurplus;

    /**
     * 限购数量[0-不限]
     */
    private Integer limitCount;

    /**
     * 商品详情
     */
    private String details;

    /**
     * 注意事项
     */
    private String notice;

    /**
     * 状态[-999-全部|-1-删除|0-未上架|1-已上架|2-定时上架]
     */
    private Integer status;

    /**
     * 定时上架-时间
     */
    private LocalDateTime startTime;

    /**
     * 定时下架-时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
