/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.DbAttributes;

public final class DbClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, DbClientAttributesGetter<REQUEST, RESPONSE>> {
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new DbClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientAttributesExtractor(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        super(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, ((DbClientAttributesGetter)this.getter).getDbQueryText(request));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, ((DbClientAttributesGetter)this.getter).getDbOperationName(request));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_SUMMARY, ((DbClientAttributesGetter)this.getter).getDbQuerySummary(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, ((DbClientAttributesGetter)this.getter).getDbQueryText(request));
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, ((DbClientAttributesGetter)this.getter).getDbOperationName(request));
        }
    }
}

